/*
 * Decompiled with CFR 0.152.
 */
package commands.changetext;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.text.AttributedText;
import document.text.TextFieldController;
import document.text.chunks.Chunk;
import java.util.ArrayList;

public class DeleteCommand
extends AbstractCommand {
    private int textToClearBegin;
    private int textToClearEnd;
    private boolean markingWasActive;
    private ArrayList<Chunk> textToClear = null;
    private int cursorBefore;
    private int cursorAfter;
    private TextFieldController controller;
    private DeleteCommandType type;

    public DeleteCommand(DeleteCommandType type, int cursorBefore, int cursorAfter, int textToClearBegin, int textToClearEnd, boolean markingWasActive, TextFieldController controller, CommandManager commandManager) {
        this.type = type;
        this.markingWasActive = markingWasActive;
        this.cursorBefore = cursorBefore;
        this.cursorAfter = cursorAfter;
        this.textToClearBegin = textToClearBegin;
        this.textToClearEnd = textToClearEnd;
        if (textToClearBegin > textToClearEnd) {
            int z = textToClearBegin;
            this.textToClearBegin = textToClearEnd;
            this.textToClearEnd = z;
        }
        if (this.textToClearBegin != this.textToClearEnd) {
            this.cursorAfter = this.textToClearBegin;
        }
        this.controller = controller;
        if (commandManager.getLastCommand() instanceof DeleteCommand) {
            DeleteCommand lastCommand = (DeleteCommand)commandManager.getLastCommand();
            if (this.textToClearBegin + 1 == this.textToClearEnd && this.type == lastCommand.type && this.cursorBefore == lastCommand.cursorAfter) {
                if (type == DeleteCommandType.delete) {
                    ++lastCommand.textToClearEnd;
                } else {
                    --lastCommand.textToClearBegin;
                    --lastCommand.cursorAfter;
                }
                this.doIt();
                if (type == DeleteCommandType.delete) {
                    lastCommand.textToClear.add(this.textToClear.get(0));
                    if (lastCommand.textToClear.size() > 1) {
                        lastCommand.textToClear.get(lastCommand.textToClear.size() - 2).merge(lastCommand.textToClear);
                    }
                } else {
                    lastCommand.textToClear.add(0, this.textToClear.get(0));
                    if (lastCommand.textToClear.size() > 1) {
                        lastCommand.textToClear.get(0).merge(lastCommand.textToClear);
                    }
                }
            } else {
                commandManager.invokeCommand(this);
            }
        } else {
            commandManager.invokeCommand(this);
        }
    }

    @Override
    public final boolean doIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        if (this.textToClearBegin != this.textToClearEnd) {
            this.textToClear = attributedText.deleteSubText(attributedText.intToChunkPosition(this.textToClearBegin), attributedText.intToChunkPosition(this.textToClearEnd));
        }
        this.controller.setMarkingActive(false);
        this.controller.setMarkStart(0);
        this.controller.setMarkEnd(0);
        this.controller.setCursor(this.cursorAfter);
        return true;
    }

    @Override
    public final boolean undoIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        if (this.textToClear != null) {
            attributedText.insertAt(this.textToClear, attributedText.intToChunkPosition(this.textToClearBegin));
        }
        if (this.textToClearBegin != this.textToClearEnd && this.markingWasActive) {
            this.controller.setMarkingActive(true);
            this.controller.setMarkStart(this.textToClearBegin);
            this.controller.setMarkEnd(this.textToClearEnd);
        }
        this.controller.setCursor(this.cursorBefore);
        return false;
    }

    public static enum DeleteCommandType {
        backspace,
        delete;

    }
}

