/*
 * Decompiled with CFR 0.152.
 */
package commands.changetext;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.text.AttributedText;
import document.text.ChunkPosition;
import document.text.TextFieldController;
import document.text.chunks.Chunk;
import java.util.ArrayList;
import util.clipboard.ClipboardHelper;

public class InsertFromClipboardCommand
extends AbstractCommand {
    private int insertPosition;
    private String text = "";
    private ArrayList<Chunk> attributedClipboardText = null;
    private int textToClearBegin;
    private int textToClearEnd;
    private ArrayList<Chunk> textToClear = null;
    private int cursorBefore;
    private int cursorAfter;
    private TextFieldController controller;
    private boolean parseMenus;

    public InsertFromClipboardCommand(int position, String text, int cursorBefore, int textToClearBegin, int textToClearEnd, boolean parseMenus, TextFieldController controller, CommandManager commandManager) {
        this.insertPosition = position;
        this.cursorBefore = cursorBefore;
        this.textToClearBegin = textToClearBegin;
        this.textToClearEnd = textToClearEnd;
        if (text != null && !text.isEmpty()) {
            this.text = text;
            this.attributedClipboardText = null;
        } else {
            this.text = ClipboardHelper.getInstance().getClipboardContents();
            this.attributedClipboardText = AttributedText.getCopy(AttributedText.getClipBoard());
        }
        this.parseMenus = parseMenus;
        if (this.textToClearBegin > this.textToClearEnd) {
            int z = this.textToClearBegin;
            this.textToClearBegin = this.textToClearEnd;
            this.textToClearEnd = z;
        }
        if (this.textToClearBegin != this.textToClearEnd) {
            this.insertPosition = this.textToClearBegin;
        }
        this.cursorAfter = this.insertPosition + text.length();
        this.controller = controller;
        commandManager.invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        if (this.textToClearBegin != this.textToClearEnd) {
            this.textToClear = attributedText.deleteSubText(attributedText.intToChunkPosition(this.textToClearBegin), attributedText.intToChunkPosition(this.textToClearEnd));
        }
        ChunkPosition end = null;
        if (this.text != null && this.text.length() > 0) {
            ChunkPosition cp = attributedText.intToChunkPosition(this.insertPosition);
            end = this.attributedClipboardText != null && AttributedText.toText(this.attributedClipboardText).compareTo(this.text) == 0 ? attributedText.insertAt(this.attributedClipboardText, cp) : (this.parseMenus ? attributedText.insertTextWithMenus(this.text, cp, attributedText.getTextStyle(cp)) : attributedText.insertAt(this.text, cp, attributedText.getTextStyle(cp), null, true));
        }
        int cursorEnd = end != null ? attributedText.chunkPositionToint(end) : this.cursorAfter;
        this.controller.setMarkingActive(false);
        this.controller.setMarkStart(0);
        this.controller.setMarkEnd(0);
        this.controller.setCursor(cursorEnd);
        return true;
    }

    @Override
    public final boolean undoIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        if (this.text.length() > 0) {
            attributedText.deleteSubText(attributedText.intToChunkPosition(this.insertPosition), attributedText.intToChunkPosition(this.insertPosition + this.text.length()));
        }
        if (this.textToClear != null) {
            attributedText.insertAt(this.textToClear, attributedText.intToChunkPosition(this.textToClearBegin));
        }
        if (this.textToClearBegin != this.textToClearEnd) {
            this.controller.setMarkingActive(true);
            this.controller.setMarkStart(this.textToClearBegin);
            this.controller.setMarkEnd(this.textToClearEnd);
        }
        this.controller.setCursor(this.cursorBefore);
        return false;
    }
}

