/*
 * Decompiled with CFR 0.152.
 */
package commands.objectaligngroupzorder;

import commands.baseclasses.AbstractCommand;
import document.MyGroup;
import document.MyObject;
import document.MyPage;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;

public class ObjectsUngroupCommand
extends AbstractCommand {
    private MarkedObjectsAndHandles stateInfo;
    private MyGroup group;

    public ObjectsUngroupCommand(MarkedObjectsAndHandles stateInfo, MyGroup group) {
        this.stateInfo = stateInfo;
        this.group = group;
        stateInfo.getMarkedObjectsPageController().getPage().getDocument().getCommandManager().invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        MyPage page = this.group.getPage();
        int index = page.getZOrder(this.group);
        page.removeObject(this.group);
        this.stateInfo.clearMarkedObjects();
        int i = this.group.size() - 1;
        while (i >= 0) {
            page.addObject(index, this.group.get(i));
            this.stateInfo.addMarkedObject(this.group.get(i));
            --i;
        }
        this.stateInfo.getHandlesOfMarkedObjects();
        return true;
    }

    @Override
    public final boolean undoIt() {
        MyPage page = this.group.getPage();
        page.addObject(page.getZOrder(this.group.get(0)), this.group);
        for (MyObject object : this.group.getObjects()) {
            page.removeObject(object);
        }
        this.stateInfo.clearMarkedObjects();
        this.stateInfo.addMarkedObject(this.group);
        this.stateInfo.getHandlesOfMarkedObjects();
        return false;
    }
}

