/*
 * Decompiled with CFR 0.152.
 */
package data.localdatabase;

import data.DataObject;
import data.localdatabase.DBExchangeObject;
import data.localdatabase.DBKlassenDaten;
import data.localdatabase.DBUserDaten;
import java.util.ArrayList;
import org.w3c.dom.Element;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class DBSchulDaten
extends DataObject {
    private DBExchangeObject exchangeObject;
    private int exchangeObjectXMLIndex;
    private ArrayList<DBKlassenDaten> classes = new ArrayList();
    private String classXMLIndices;
    private ArrayList<DBUserDaten> users = new ArrayList();
    private String userXMLIndices;

    public DBSchulDaten(DBExchangeObject exchangeObject) {
        this.exchangeObject = exchangeObject;
    }

    public ArrayList<DBUserDaten> getUsers() {
        this.retrieveDataFromDatabase();
        return this.users;
    }

    public DBExchangeObject getExchangeObject() {
        return this.exchangeObject;
    }

    public void setExchangeObject(DBExchangeObject exchangeObject) {
        this.exchangeObject = exchangeObject;
    }

    public ArrayList<DBKlassenDaten> getClasses(DBUserDaten user) {
        this.retrieveDataFromDatabase();
        ArrayList<DBKlassenDaten> userKlassen = new ArrayList<DBKlassenDaten>();
        for (DBKlassenDaten klasse : this.classes) {
            if (!klasse.getUsers().contains(user)) continue;
            userKlassen.add(klasse);
        }
        return userKlassen;
    }

    public ArrayList<DBKlassenDaten> getClasses() {
        return this.classes;
    }

    @Override
    public void cleanbuffer() {
    }

    @Override
    protected ArrayList<DataObject> getBufferedObjects() {
        return null;
    }

    @Override
    protected int getMaxBufferedObjects() {
        return 0;
    }

    @Override
    protected void retrieveDataFromDatabase() {
        if (DBSchulDaten.getDatabaseInterface() != null) {
            if (this.classes.size() == 0) {
                for (DBUserDaten userData : this.users) {
                    ArrayList<Object> classIndices = DBSchulDaten.getDatabaseInterface().getClassIndices(this.getIndex(), userData.getIndex());
                    DBKlassenDaten classData_z = null;
                    for (Object classIndex : classIndices) {
                        boolean exists = false;
                        for (DBKlassenDaten classData : this.classes) {
                            if (classData.getIndex() != classIndex) continue;
                            exists = true;
                            classData_z = classData;
                            break;
                        }
                        if (!exists) {
                            classData_z = new DBKlassenDaten(this);
                            classData_z.setIndex(classIndex);
                            this.classes.add(classData_z);
                        }
                        classData_z.getUsers().add(userData);
                    }
                }
            }
            this.clear();
            DBSchulDaten.getDatabaseInterface().getSchoolData(this.getIndex(), this);
            this.setEmpty(false);
        }
    }

    @Override
    public String toString() {
        return this.getStringValueNotNull("name");
    }

    @Override
    public void deserialize(Element element) {
        this.deserializeKeyValuePairs(element);
        this.exchangeObjectXMLIndex = XMLReader.elementIntegerAttribute(element, "p_exchangeObjectIndex");
        this.classXMLIndices = XMLReader.attributeNotNull(element, "p_klassenXMLIndices");
        this.userXMLIndices = XMLReader.attributeNotNull(element, "p_userXMLIndices");
    }

    @Override
    public DataObject getNewInstance() {
        return new DBSchulDaten(null);
    }

    @Override
    public void resolveXMLIndices() {
        this.exchangeObject = (DBExchangeObject)DBSchulDaten.getDeserializedObject(this.exchangeObjectXMLIndex);
        this.classes.clear();
        ArrayList<Integer> numbers = this.StringListToInt(this.classXMLIndices);
        for (Integer number : numbers) {
            this.classes.add((DBKlassenDaten)DBSchulDaten.getDeserializedObject(number));
        }
        this.users.clear();
        numbers = this.StringListToInt(this.userXMLIndices);
        for (Integer number : numbers) {
            this.users.add((DBUserDaten)DBSchulDaten.getDeserializedObject(number));
        }
    }

    @Override
    public void serialize(Element parentElement) {
        Element element = XMLWriter.addElement(this.getXMLName(), parentElement);
        this.serializeKeyValuePairs(element);
        XMLWriter.addAttributeInt(element, "p_exchangeObjectIndex", this.exchangeObject.getXMLIndex());
        StringBuffer indexBuffer = new StringBuffer();
        int i = 0;
        while (i < this.classes.size()) {
            indexBuffer.append(this.classes.get(i).getXMLIndex());
            if (i < this.classes.size() - 1) {
                indexBuffer.append(',');
            }
            ++i;
        }
        XMLWriter.addAttribute(element, "p_klassenXMLIndices", indexBuffer.toString());
        indexBuffer = new StringBuffer();
        i = 0;
        while (i < this.users.size()) {
            indexBuffer.append(this.users.get(i).getXMLIndex());
            if (i < this.users.size() - 1) {
                indexBuffer.append(',');
            }
            ++i;
        }
        XMLWriter.addAttribute(element, "p_userXMLIndices", indexBuffer.toString());
    }

    public String getXMLName() {
        return "schule";
    }
}

