/*
 * Decompiled with CFR 0.152.
 */
package document;

import document.Serializable;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.w3c.dom.Element;
import util.logging.Log;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class MyFilling
implements Serializable {
    private FillMode fillMode = FillMode.color;
    private int alphaValue = 255;
    private Color color = Color.blue;
    private BufferedImage texture;
    private Rectangle2D rectangle;
    Point2D.Float p1;
    Point2D.Float p2;
    Color color1;
    Color color2;
    boolean cyclic;

    public void copyTo(MyFilling fobject) {
        fobject.alphaValue = this.alphaValue;
        switch (this.fillMode) {
            case color: {
                fobject.setColorPaint(this.color);
                break;
            }
            case texture: {
                fobject.setTexturePaint(this.texture, this.rectangle);
                break;
            }
            case gradient: {
                fobject.setGradientPaint(this.p1, this.color1, this.p2, this.color2, this.cyclic);
                break;
            }
            case none: {
                fobject.setNoPaint();
                break;
            }
        }
    }

    public void setNoPaint() {
        this.fillMode = FillMode.none;
    }

    public void setTexturePaint(BufferedImage texture, Rectangle2D rectangle) {
        this.fillMode = FillMode.texture;
        this.texture = texture;
        this.rectangle = rectangle;
    }

    public void setColorPaint(Color c) {
        this.fillMode = FillMode.color;
        this.color = c;
        this.alphaValue = c.getAlpha();
    }

    public void setGradientPaint(Point2D pt1, Color color1, Point2D pt2, Color color2, boolean cyclic) {
        this.fillMode = FillMode.gradient;
        this.p1 = new Point2D.Float((float)pt1.getX(), (float)pt1.getY());
        this.p2 = new Point2D.Float((float)pt2.getX(), (float)pt2.getY());
        this.color1 = color1;
        this.color2 = color2;
        this.cyclic = cyclic;
    }

    public void setGradientPaint(float x1, float y1, Color color1, float x2, float y2, Color color2, boolean cyclic) {
        this.fillMode = FillMode.gradient;
        if (color1 == null || color2 == null) {
            Log.log(4, "FyFillableObject.SetGradientPaint: Colors cannot be null");
        }
        this.p1 = new Point2D.Float(x1, y1);
        this.p2 = new Point2D.Float(x2, y2);
        this.color1 = color1;
        this.color2 = color2;
        this.cyclic = cyclic;
    }

    public void setPaint(Graphics2D g2d) {
        switch (this.fillMode) {
            case none: {
                break;
            }
            case color: {
                g2d.setPaint(this.color);
                break;
            }
            case texture: {
                g2d.setPaint(new TexturePaint(this.texture, this.rectangle));
                break;
            }
            case gradient: {
                g2d.setPaint(new GradientPaint(this.p1, this.color1, this.p2, this.color2, this.cyclic));
                break;
            }
        }
    }

    public FillMode getFillMode() {
        return this.fillMode;
    }

    public boolean isPainted() {
        return this.fillMode != FillMode.none;
    }

    public MyFilling getCopy() {
        MyFilling f = new MyFilling();
        this.copyTo(f);
        return f;
    }

    public void setAlpha(int alphaValue) {
        this.alphaValue = alphaValue;
        if (this.color != null) {
            Color color1;
            this.color = color1 = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), alphaValue);
        }
    }

    public int getAlpha() {
        return this.alphaValue;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void deSerialize(Element element) {
        String s;
        Color c;
        Integer i = XMLReader.elementIntegerAttribute(element, "alpha");
        if (i != null) {
            this.alphaValue = i;
        }
        if ((c = XMLReader.elementColorAttribute(element, "color")) != null) {
            this.color = c;
        }
        if ((s = XMLReader.attribute(element, "fillmode")) != null) {
            this.fillMode = FillMode.valueOf(s);
        }
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement("filling", parentElement);
        XMLWriter.addAttributeInt(element, "alpha", this.alphaValue);
        XMLWriter.addAttributeColor(element, "color", this.color);
        XMLWriter.addAttribute(element, "fillmode", this.fillMode.toString());
        return element;
    }

    public static String getXMLName() {
        return "filling";
    }

    public static enum FillMode {
        none,
        color,
        texture,
        gradient;

    }
}

