/*
 * Decompiled with CFR 0.152.
 */
package document;

import document.MyFillableObject;
import document.MyFilling;
import document.MyLine;
import document.MyObject;
import document.ObjectFactory;
import document.Renderable;
import document.events.Eventtype;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.graphiccontext.GraphicContext;
import gui.components.pageviewport.handles.HandleController;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import util.math.MyMath;
import util.math.PointDouble;
import util.math.RectangleDouble;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class MyGroup
extends MyFillableObject {
    private ArrayList<MyObject> objects = new ArrayList();
    private MyGroup isExactCopyOf = null;
    boolean allAnglesEqual = false;

    public void clear() {
        this.objects.clear();
        super.setIsEditingAllowedInFillinModus(MyObject.EditingAllowedInFillinModus.notKnown);
    }

    @Override
    protected void makeShape() {
    }

    @Override
    public Renderable.ObjectType getType() {
        return Renderable.ObjectType.group;
    }

    @Override
    public boolean isInside(PointDouble pPage) {
        for (MyObject object : this.objects) {
            if (!object.isInside(pPage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MyObject getCopy() {
        MyGroup object = new MyGroup();
        this.copyTo(object);
        return object;
    }

    @Override
    public void copyTo(MyObject object) {
        super.copyTo(object);
        MyGroup group = (MyGroup)object;
        if (group.isExactCopyOf == this) {
            int i = 0;
            while (i < this.objects.size()) {
                MyObject original = this.objects.get(i);
                MyObject copy = group.objects.get(i);
                original.copyTo(copy);
                ++i;
            }
        } else {
            group.clear();
            int i = 0;
            while (i < this.objects.size()) {
                MyObject original = this.objects.get(i);
                MyObject copy = original.getCopy();
                group.add(copy);
                ++i;
            }
            group.isExactCopyOf = this;
        }
        group.setMetrics();
    }

    @Override
    public void makePreview() {
        MyGroup group = new MyGroup();
        int i = 0;
        while (i < this.objects.size()) {
            MyObject original = this.objects.get(i);
            original.makePreview();
            MyObject copy = original.getPreviewObject();
            group.add(copy);
            ++i;
        }
        group.isExactCopyOf = this;
        group.setMetrics();
        this.previewObject = group;
    }

    @Override
    public void releasePreview() {
        if (this.previewObject != null) {
            for (MyObject object : this.objects) {
                object.releasePreview();
            }
        }
        this.previewObject = null;
    }

    @Override
    public void move(double dx, double dy) {
        super.move(dx, dy);
        for (MyObject object : this.objects) {
            object.move(dx, dy);
        }
    }

    @Override
    public void moveTo(PointDouble newMid) {
        double dx = newMid.x - this.midX;
        double dy = newMid.y - this.midY;
        this.move(dx, dy);
    }

    public void setMetrics() {
        this.determineEqualAttributes();
        double left = 100000.0;
        double right = -100000.0;
        double top = 100000.0;
        double bottom = -100000.0;
        PointDouble mid = new PointDouble(0.0, 0.0);
        if (this.allAnglesEqual) {
            for (MyObject object : this.objects) {
                if (!(object instanceof MyLine)) {
                    mid.setLocation(object.midX, object.midY);
                    MyMath.rotate(mid, 0.0, 0.0, -this.angle);
                    left = MyMath.min(left, mid.getX() - object.width / 2.0);
                    right = MyMath.max(right, mid.getX() + object.width / 2.0);
                    top = MyMath.min(top, mid.getY() - object.height / 2.0);
                    bottom = MyMath.max(bottom, mid.getY() + object.height / 2.0);
                    continue;
                }
                MyLine line = (MyLine)object;
                mid.setLocation(line.getP1());
                MyMath.rotate(mid, 0.0, 0.0, -this.angle);
                left = MyMath.min(left, mid.getX());
                right = MyMath.max(right, mid.getX());
                top = MyMath.min(top, mid.getY());
                bottom = MyMath.max(bottom, mid.getY());
                mid.setLocation(line.getP2());
                MyMath.rotate(mid, 0.0, 0.0, -this.angle);
                left = MyMath.min(left, mid.getX());
                right = MyMath.max(right, mid.getX());
                top = MyMath.min(top, mid.getY());
                bottom = MyMath.max(bottom, mid.getY());
            }
            mid.setLocation((right + left) / 2.0, (top + bottom) / 2.0);
            MyMath.rotate(mid, 0.0, 0.0, this.angle);
            this.midX = mid.getX();
            this.midY = mid.getY();
        } else {
            for (MyObject object : this.objects) {
                RectangleDouble box = object.getBoundingBox();
                left = MyMath.min(left, box.getLeft());
                right = MyMath.max(right, box.getRight());
                top = MyMath.min(top, box.getTop());
                bottom = MyMath.max(bottom, box.getBottom());
            }
            this.midX = (right + left) / 2.0;
            this.midY = (top + bottom) / 2.0;
        }
        this.width = right - left;
        this.height = bottom - top;
    }

    public void add(MyObject object) {
        if (!this.objects.contains(object)) {
            if (this.objects.size() == 0) {
                this.page = object.page;
            }
            this.objects.add(object);
            this.setMetrics();
        }
        super.setIsEditingAllowedInFillinModus(MyObject.EditingAllowedInFillinModus.notKnown);
        if (!this.isPreviewObject()) {
            this.setDirty();
        }
    }

    public void remove(MyObject object) {
        this.objects.remove(object);
        super.setIsEditingAllowedInFillinModus(MyObject.EditingAllowedInFillinModus.notKnown);
        this.setMetrics();
    }

    @Override
    public void getHandles(ArrayList<HandleController> handleList, PageViewport pageViewPort) {
        if (this.objects.size() > 0) {
            if (this.objects.size() == 1) {
                this.objects.get(0).getHandles(handleList, pageViewPort);
            } else {
                if (this.allAnglesEqual) {
                    this.getDiagonalStretchingHandles(handleList, pageViewPort, false);
                    this.getHorVertStretchingHandles(handleList, pageViewPort);
                } else {
                    this.getDiagonalStretchingHandles(handleList, pageViewPort, true);
                }
                this.getRotateHandle(handleList, pageViewPort);
            }
        }
    }

    public ArrayList<MyObject> getObjects() {
        return this.objects;
    }

    public int size() {
        return this.objects.size();
    }

    public MyObject get(int i) {
        return this.objects.get(i);
    }

    @Override
    public void stretch(PointDouble center, double factor) {
        super.stretch(center, factor);
        for (MyObject object : this.objects) {
            object.stretch(center, factor);
        }
        this.setMetrics();
    }

    @Override
    public void stretch(PointDouble center, double factorHor, double factorVert) {
        center = center.getCopy();
        super.stretch(center, factorHor, factorVert);
        for (MyObject object : this.objects) {
            if (object instanceof MyLine) {
                ((MyLine)object).stretch(center, factorHor, factorVert, this.angle);
                continue;
            }
            object.stretch(center, factorHor, factorVert);
        }
        this.setMetrics();
    }

    @Override
    public void rotate(PointDouble center, double angle) {
        for (MyObject object : this.objects) {
            object.rotate(center, angle);
        }
        this.setMetrics();
    }

    public void determineEqualAttributes() {
        this.allAnglesEqual = true;
        if (this.objects.size() > 0) {
            double firstAngle = this.objects.get(0).getAngle();
            for (MyObject object : this.objects) {
                if (!(Math.abs(object.getAngle() - firstAngle) > 1.0E-6) || object instanceof MyLine) continue;
                this.allAnglesEqual = false;
                break;
            }
            this.angle = this.allAnglesEqual ? firstAngle : 0.0;
        }
    }

    @Override
    public void setFilling(MyFilling filling) {
        for (MyObject object : this.objects) {
            if (!(object instanceof MyFillableObject)) continue;
            ((MyFillableObject)object).setFilling(filling.getCopy());
        }
    }

    @Override
    public void setFillingAlpha(int alphaValue) {
        for (MyObject object : this.objects) {
            if (!(object instanceof MyFillableObject)) continue;
            ((MyFillableObject)object).setFillingAlpha(alphaValue);
        }
    }

    public void setLineAlpha(int alpha) {
        for (MyObject object : this.objects) {
            if (!(object instanceof MyObject)) continue;
            object.getLineStyle().setAlpha(alpha);
        }
    }

    @Override
    public void render(GraphicContext gc, boolean isPreview) {
        for (MyObject object : this.objects) {
            object.render(gc, isPreview);
        }
    }

    public static String getXMLName() {
        return "group";
    }

    @Override
    public void deSerialize(Element element) {
        super.deSerialize(element);
        List<Element> elements = XMLReader.elements(element);
        for (Element childElement : elements) {
            MyObject object = ObjectFactory.deSerialize(childElement, this.page);
            if (object == null) continue;
            this.objects.add(object);
        }
        this.setMetrics();
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(MyGroup.getXMLName(), parentElement);
        super.serialize(element);
        for (MyObject object : this.objects) {
            object.serialize(element);
        }
        return element;
    }

    @Override
    public MyObject.EditingAllowedInFillinModus getIsEditingAllowedInFillinModus() {
        if (super.getIsEditingAllowedInFillinModus() == MyObject.EditingAllowedInFillinModus.notKnown) {
            this.checkIsEditingAllowed();
        }
        return super.getIsEditingAllowedInFillinModus();
    }

    @Override
    public void setIsEditingAllowedInFillinModus(MyObject.EditingAllowedInFillinModus isEditingAllowedInFillinModus) {
        for (MyObject object : this.objects) {
            object.setIsEditingAllowedInFillinModus(isEditingAllowedInFillinModus);
        }
        super.setIsEditingAllowedInFillinModus(isEditingAllowedInFillinModus);
    }

    public void checkIsEditingAllowed() {
        MyObject.EditingAllowedInFillinModus allowed;
        if (this.objects.size() > 0) {
            allowed = this.objects.get(0).getIsEditingAllowedInFillinModus();
            if (allowed != MyObject.EditingAllowedInFillinModus.indefinite) {
                for (MyObject object : this.objects) {
                    if (allowed == object.getIsEditingAllowedInFillinModus()) continue;
                    allowed = MyObject.EditingAllowedInFillinModus.indefinite;
                    break;
                }
            }
        } else {
            allowed = MyObject.EditingAllowedInFillinModus.indefinite;
        }
        super.setIsEditingAllowedInFillinModus(allowed);
    }

    @Override
    public Eventtype[] getPossibleEvents() {
        return null;
    }
}

