/*
 * Decompiled with CFR 0.152.
 */
package document;

import document.MyFillableObject;
import document.MyObject;
import document.Renderable;
import document.Serializable;
import document.events.Eventtype;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.graphiccontext.GraphicContext;
import gui.components.pageviewport.handles.HandleController;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.w3c.dom.Element;
import util.math.MyMath;
import util.math.PointDouble;
import util.xml.XMLWriter;

public class MyRectangle
extends MyFillableObject
implements Renderable,
Serializable {
    public static String getXMLName() {
        return "rectangle";
    }

    public MyRectangle() {
        this(1.0, 1.0, 1.0, 1.0, 0.0);
    }

    public MyRectangle(double midx, double midy, double width, double height, double angle) {
        this.midX = midx;
        this.midY = midy;
        this.width = width;
        this.height = height;
        this.angle = angle;
        this.makeShape();
    }

    @Override
    public void copyTo(MyObject object) {
        super.copyTo(object);
    }

    @Override
    public Renderable.ObjectType getType() {
        return Renderable.ObjectType.rectangle;
    }

    @Override
    public boolean isInside(PointDouble pPage) {
        if (this.isInBoundigBox(pPage)) {
            boolean inStroke;
            PointDouble pz = pPage.getCopy();
            MyMath.rotate(pz, this.midX, this.midY, -this.angle);
            double x = pz.getX();
            double y = pz.getY();
            double halfStrokeWidth = this.getStrokeWidth() / 2.0;
            if (halfStrokeWidth < 0.05) {
                halfStrokeWidth = 0.05;
            }
            boolean inPaint = x >= this.midX - this.width / 2.0 && x <= this.midX + this.width / 2.0 && y >= this.midY - this.height / 2.0 && y <= this.midY + this.height / 2.0;
            boolean bl = inStroke = y >= this.midY - this.height / 2.0 - halfStrokeWidth && y <= this.midY + this.height / 2.0 + halfStrokeWidth && (x >= this.midX - this.width / 2.0 - halfStrokeWidth && x <= this.midX - this.width / 2.0 + halfStrokeWidth || x >= this.midX + this.width / 2.0 - halfStrokeWidth && x <= this.midX + this.width / 2.0 + halfStrokeWidth) || x >= this.midX - this.width / 2.0 - halfStrokeWidth && x <= this.midX + this.width / 2.0 + halfStrokeWidth && (y >= this.midY - this.height / 2.0 - halfStrokeWidth && y <= this.midY - this.height / 2.0 + halfStrokeWidth || y >= this.midY + this.height / 2.0 - halfStrokeWidth && y <= this.midY + this.height / 2.0 + halfStrokeWidth);
            return this.isPainted() && inPaint || this.isStroked() && inStroke;
        }
        return false;
    }

    @Override
    protected void makeShape() {
        this.shape = new Rectangle2D.Double(this.midX - this.width / 2.0, this.midY - this.height / 2.0, this.width, this.height);
    }

    @Override
    public MyObject getCopy() {
        MyRectangle object = new MyRectangle(0.0, 0.0, 0.0, 0.0, 0.0);
        this.copyTo(object);
        return object;
    }

    @Override
    public void getHandles(ArrayList<HandleController> handleList, PageViewport pageViewPort) {
        this.getDiagonalStretchingHandles(handleList, pageViewPort, false);
        this.getHorVertStretchingHandles(handleList, pageViewPort);
        this.getRotateHandle(handleList, pageViewPort);
    }

    @Override
    public void render(GraphicContext gc, boolean isPreview) {
        AffineTransform OldTransform = gc.getTransform();
        gc.setPageCoordinates();
        if (Math.abs(this.getAngle()) > 1.0E-4) {
            gc.rotate(-this.getAngle(), this.getMidX(), this.getMidY());
        }
        if (this.isPainted()) {
            this.setPaint(gc);
            gc.fill(this.getShape());
        }
        if (this.isStroked()) {
            this.setStroke(gc);
            gc.draw(this.getShape());
        }
        gc.setTransform(OldTransform);
    }

    @Override
    public void deSerialize(Element element) {
        super.deSerialize(element);
        this.makeShape();
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(MyRectangle.getXMLName(), parentElement);
        super.serialize(element);
        return element;
    }

    @Override
    public Eventtype[] getPossibleEvents() {
        return null;
    }
}

