/*
 * Decompiled with CFR 0.152.
 */
package document.text;

import document.text.AttributedText;
import document.text.TextStyle;
import document.text.chunks.Chunk;
import java.awt.Color;
import java.util.ArrayList;

public class TextStyleFactory {
    private ArrayList<TextStyle> styles = new ArrayList();
    private static TextStyleFactory instance;

    public static TextStyleFactory getInstance() {
        if (instance == null) {
            instance = new TextStyleFactory();
        }
        return instance;
    }

    private TextStyleFactory() {
    }

    private TextStyle searchStyle(String fontName, int size, Color fontColor, boolean isUnderlined, boolean isBold, boolean isItalic) {
        TextStyle style = null;
        for (TextStyle ts : this.styles) {
            if (ts.getFontName() != fontName || ts.getSize() != size || !this.isIdenticalColor(ts.getFontColor(), fontColor) || ts.isUnderlined() != isUnderlined || ts.isBold() != isBold || ts.isItalic() != isItalic) continue;
            style = ts;
            break;
        }
        return style;
    }

    public TextStyle getTextStyle(String fontName, int size, Color fontColor, boolean isUnderlined, boolean isBold, boolean isItalic) {
        TextStyle style = this.searchStyle(fontName, size, fontColor, isUnderlined, isBold, isItalic);
        if (style == null) {
            style = new TextStyle(fontName, size, fontColor, isUnderlined, isBold, isItalic);
            this.styles.add(style);
        }
        return style;
    }

    public void eliminateUnusedTextStyles(AttributedText attributedText) {
        boolean[] isUsed = new boolean[attributedText.chunks.size()];
        int i = 0;
        while (i < isUsed.length) {
            isUsed[i] = false;
            ++i;
        }
        for (Chunk chunk : attributedText.chunks) {
            int index = this.styles.indexOf(chunk.getTextStyle());
            if (index <= 0 || index >= isUsed.length) continue;
            isUsed[index] = true;
        }
        i = isUsed.length - 1;
        while (i >= 0) {
            if (!isUsed[i]) {
                this.styles.remove(i);
            }
            --i;
        }
    }

    private boolean isIdenticalColor(Color c1, Color c2) {
        return c1.getRed() == c2.getRed() && c1.getBlue() == c2.getBlue() && c1.getGreen() == c2.getGreen();
    }
}

