/*
 * Decompiled with CFR 0.152.
 */
package document.text.chunks;

import document.Serializable;
import document.text.AttributedText;
import document.text.ChunkPosition;
import document.text.Line;
import document.text.TextStyle;
import document.text.TextStyleFactory;
import document.text.chunks.LineBreak;
import document.text.chunks.TextChunk;
import document.text.chunks.WhiteSpace;
import java.awt.Color;
import java.util.ArrayList;
import util.math.PointFloat;

public abstract class Chunk
implements Serializable {
    private int chunkNumber;
    private static int nextChunkNumber = 0;
    private long timeStamp;
    protected TextStyle textStyle;
    protected ChunkType type;
    protected float width;
    protected float ascent;
    protected float descent;
    protected float leading;
    protected float advance;
    protected AttributedText attributedText;

    public Chunk(AttributedText attributedText) {
        this.attributedText = attributedText;
        this.textStyle = TextStyleFactory.getInstance().getTextStyle("Arial", 12, Color.black, false, false, false);
        this.timeStamp = attributedText.getTimeStamp();
        this.chunkNumber = nextChunkNumber++;
    }

    public Chunk(AttributedText attributedText, TextStyle ts) {
        this.attributedText = attributedText;
        this.textStyle = ts;
        this.timeStamp = attributedText.getTimeStamp();
        this.chunkNumber = nextChunkNumber++;
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(TextStyle textStyle) {
        this.textStyle = textStyle;
        this.calculateMetrics();
    }

    public boolean isTextChunk() {
        return this instanceof TextChunk;
    }

    public boolean isWhiteSpace() {
        return this instanceof WhiteSpace;
    }

    public boolean isLineBreak() {
        return this instanceof LineBreak;
    }

    public float getWidth() {
        return this.width;
    }

    public float getAscent() {
        return this.ascent;
    }

    public float getDescent() {
        return this.descent;
    }

    public float getAdvance() {
        return this.advance;
    }

    public abstract void calculateMetrics();

    public Chunk getNextChunk() {
        return this.attributedText.getNextChunk(this);
    }

    public Chunk getPreviousChunk() {
        return this.attributedText.getPreviousChunk(this);
    }

    public abstract int getLength();

    public float getLeading() {
        return this.leading;
    }

    public void setFontName(String fontName) {
        this.textStyle = TextStyleFactory.getInstance().getTextStyle(fontName, this.textStyle.getSize(), this.textStyle.getFontColor(), this.textStyle.isUnderlined(), this.textStyle.isBold(), this.textStyle.isItalic());
        this.calculateMetrics();
    }

    public void setFontSize(int fontSize) {
        this.textStyle = TextStyleFactory.getInstance().getTextStyle(this.textStyle.getFontName(), fontSize, this.textStyle.getFontColor(), this.textStyle.isUnderlined(), this.textStyle.isBold(), this.textStyle.isItalic());
        this.calculateMetrics();
    }

    public void setFontColor(Color color) {
        this.textStyle = TextStyleFactory.getInstance().getTextStyle(this.textStyle.getFontName(), this.textStyle.getSize(), color, this.textStyle.isUnderlined(), this.textStyle.isBold(), this.textStyle.isItalic());
    }

    public void setUnderlined(boolean isUnderlined) {
        this.textStyle = TextStyleFactory.getInstance().getTextStyle(this.textStyle.getFontName(), this.textStyle.getSize(), this.textStyle.getFontColor(), isUnderlined, this.textStyle.isBold(), this.textStyle.isItalic());
    }

    public void setBold(boolean isBold) {
        this.textStyle = TextStyleFactory.getInstance().getTextStyle(this.textStyle.getFontName(), this.textStyle.getSize(), this.textStyle.getFontColor(), this.textStyle.isUnderlined(), isBold, this.textStyle.isItalic());
        this.calculateMetrics();
    }

    public void setItalic(boolean isItalic) {
        this.textStyle = TextStyleFactory.getInstance().getTextStyle(this.textStyle.getFontName(), this.textStyle.getSize(), this.textStyle.getFontColor(), this.textStyle.isUnderlined(), this.textStyle.isBold(), isItalic);
        this.calculateMetrics();
    }

    public abstract void split(int var1);

    public abstract void merge(ArrayList<Chunk> var1);

    public abstract Chunk getCopyOfPart(int var1, int var2);

    public abstract Chunk getCopy();

    public abstract ChunkPosition getHitPosition(float var1, float var2, Line var3, float var4, float var5, int var6);

    public LineBreak getNextLineBreak() {
        return this.attributedText.getNextLineBreak(this);
    }

    public int getIndex() {
        return this.attributedText.chunks.indexOf(this);
    }

    public abstract PointFloat getPosition(float var1, float var2, int var3, Line var4);

    public ChunkType getType() {
        return this.type;
    }

    public abstract Chunk getSubChunkLeft(int var1);

    public abstract Chunk getSubChunkRight(int var1);

    public abstract Chunk getSubChunkMid(int var1, int var2);

    public abstract String getAsString();

    public void setAttributedText(AttributedText attributedText) {
        this.attributedText = attributedText;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setDirty() {
        this.timeStamp = this.attributedText.getTimeStamp();
    }

    public int getChunkNumber() {
        return this.chunkNumber;
    }

    public static enum ChunkType {
        text,
        whitespace,
        linebreak;

    }
}

