/*
 * Decompiled with CFR 0.152.
 */
package document.text.hyphenation;

import document.text.hyphenation.Hyphenator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class AlgorithmHyphenator
implements Hyphenator {
    public int[] positions = new int[100];
    public boolean trace = false;
    private HashSet<String> knownWordHashSet = this.newKnownWordHashSet();
    private HashMap<String, byte[]> wordHashMap = new HashMap();
    private HashSet<String> syllHashSet = this.newSyllHashSet();

    @Override
    public byte[] getHyphenationArray(String s) {
        return this.spellWord(s);
    }

    private HashSet<String> newKnownWordHashSet() {
        HashSet<String> newHashSet = new HashSet<String>();
        newHashSet.add("seiten");
        newHashSet.add("autoren");
        newHashSet.add("gesamt");
        return newHashSet;
    }

    private HashSet<String> newSyllHashSet() {
        HashSet<String> newHashSet = new HashSet<String>();
        newHashSet.add("an");
        newHashSet.add("trag");
        newHashSet.add("sch\u00e4fts");
        newHashSet.add("chen");
        newHashSet.add("gen");
        newHashSet.add("dung");
        newHashSet.add("nung");
        newHashSet.add("rung");
        newHashSet.add("tung");
        newHashSet.add("dungs");
        newHashSet.add("nungs");
        newHashSet.add("rungs");
        newHashSet.add("tungs");
        newHashSet.add("ent");
        newHashSet.add("auf");
        newHashSet.add("trag");
        newHashSet.add("lis");
        newHashSet.add("in");
        newHashSet.add("tion");
        newHashSet.add("grund");
        newHashSet.add("gr\u00fcnd");
        newHashSet.add("\ufffdnderung");
        newHashSet.add("be");
        newHashSet.add("ver");
        newHashSet.add("lauf");
        newHashSet.add("schreib");
        newHashSet.add("ngen");
        newHashSet.add("ten");
        newHashSet.add("treten");
        newHashSet.add("mit");
        newHashSet.add("pro");
        newHashSet.add("jekt");
        newHashSet.add("re");
        newHashSet.add("agieren");
        newHashSet.add("arbeit");
        newHashSet.add("schaft");
        newHashSet.add("schaf");
        newHashSet.add("tr\u00e4nke");
        newHashSet.add("gesamt");
        newHashSet.add("samt");
        newHashSet.add("autor");
        newHashSet.add("rungs");
        newHashSet.add("text");
        return newHashSet;
    }

    public byte[] spellWord(String paStrWord) {
        byte[] retStrArr = null;
        retStrArr = this.wordHashMap.get(paStrWord);
        if (retStrArr != null) {
            return retStrArr;
        }
        ArrayList<String> arrList = new ArrayList<String>();
        paStrWord = paStrWord.trim();
        String strPreSyllable = "";
        String strPreSyllables = "";
        while (paStrWord.length() > 0) {
            String syllable;
            if (this.trace) {
                System.out.println("-----------------------------------------------------");
            }
            if ((syllable = this.parseSyllable(paStrWord, strPreSyllable, strPreSyllables)).endsWith(" ")) {
                syllable = syllable.substring(0, syllable.length() - 1);
            }
            paStrWord = paStrWord.substring(syllable.length());
            arrList.add(syllable);
            strPreSyllable = syllable;
            strPreSyllables = String.valueOf(strPreSyllables) + syllable;
        }
        retStrArr = new byte[arrList.size() - 1];
        int pos = 0;
        int i = 0;
        while (i < arrList.size() - 1) {
            retStrArr[i] = pos = (int)((byte)(pos + ((String)arrList.get(i)).length()));
            ++i;
        }
        this.wordHashMap.put(paStrWord, retStrArr);
        return retStrArr;
    }

    private String parseSyllable(String paStr, String paStrPreSyllable, String paStrPreSyllables) {
        int i = 0;
        boolean bCkToKK = false;
        boolean bCont = true;
        while (bCont) {
            bCont = false;
            boolean bMatch = false;
            while (!bMatch && i < paStr.length() && AlgorithmHyphenator.isConsonant(paStr.charAt(i))) {
                bMatch = this.checkKnownSyllable(paStr.substring(0, Math.min(i, paStr.length())), paStr.substring(Math.min(i, paStr.length())));
                ++i;
            }
            while (!bMatch && i < paStr.length() && AlgorithmHyphenator.isVocal(paStr.charAt(i))) {
                bMatch = this.checkKnownSyllable(paStr.substring(0, Math.min(i, paStr.length())), paStr.substring(Math.min(i, paStr.length())));
                ++i;
            }
            while (!bMatch && i < paStr.length() - 1 && AlgorithmHyphenator.isConsonant(paStr.charAt(i + 1))) {
                bMatch = this.checkKnownSyllable(paStr.substring(0, Math.min(i, paStr.length())), paStr.substring(Math.min(i, paStr.length())));
                ++i;
            }
            if (this.trace) {
                System.out.println("vor den Regeln: " + paStr.substring(0, Math.min(i, paStr.length())) + "|" + paStr.substring(Math.min(i, paStr.length())));
            }
            if (bMatch) {
                --i;
                continue;
            }
            if (this.checkKnownSyllable(paStr.substring(0, Math.min(i, paStr.length())), paStr.substring(Math.min(i, paStr.length())))) {
                if (!this.trace) continue;
                System.out.println("Trennung zweier bekannter Silben aufgetreten " + paStr.substring(i));
                continue;
            }
            if (this.checkKnownSyllable(paStr.substring(0, Math.min(i + 1, paStr.length())), paStr.substring(Math.min(i + 1, paStr.length())))) {
                if (this.trace) {
                    System.out.println("Trennung zweier bekannter Silben an Folgeposition 1 aufgetreten " + paStr.substring(i));
                }
                ++i;
                continue;
            }
            if (this.checkKnownSyllable(paStr.substring(0, Math.min(i + 2, paStr.length())), paStr.substring(Math.min(i + 2, paStr.length())))) {
                if (this.trace) {
                    System.out.println("Trennung zweier bekannter Silben an Folgeposition 2 aufgetreten " + paStr.substring(i));
                }
                i += 2;
                continue;
            }
            if (i > 1 && i < paStr.length() - 1 && paStr.substring(i - 1).startsWith("st")) {
                if (this.trace) {
                    System.out.println("st wurde getrennt " + paStr.substring(i));
                }
                --i;
                continue;
            }
            if (i < paStr.length() - 1 && paStr.substring(i).startsWith("st")) {
                if (this.trace) {
                    System.out.println("st am Ende der Silbe " + paStr.substring(i));
                }
                i += 2;
                continue;
            }
            if (i < paStr.length() - 1 && paStr.substring(i).startsWith("ft")) {
                if (this.trace) {
                    System.out.println("ft am Ende der Silbe " + paStr.substring(i));
                }
                i += 2;
                continue;
            }
            if (i > 2 && i < paStr.length() - 1 && paStr.substring(i - 2).startsWith("sch")) {
                if (this.trace) {
                    System.out.println("sch wurde getrennt " + paStr.substring(i));
                }
                i -= 2;
                continue;
            }
            if (i > 1 && i < paStr.length() - 1 && paStr.substring(i - 1).startsWith("ch")) {
                if (this.trace) {
                    System.out.println("ch wurde getrennt " + paStr.substring(i));
                }
                --i;
                continue;
            }
            if (i > 2 && i < paStr.length() - 1 && paStr.substring(i - 2).startsWith("str")) {
                if (this.trace) {
                    System.out.println("str am Anfang der n\u00e4chsten Silbe " + paStr.substring(i));
                }
                i -= 2;
                continue;
            }
            if (i > 1 && i < paStr.length() - 1 && paStr.substring(i - 1).startsWith("c") && i < paStr.length() - 1 && paStr.substring(i).startsWith("k")) {
                if (this.trace) {
                    System.out.println("ck wird in kk umgewandelt " + paStr.substring(i));
                }
                bCkToKK = true;
                continue;
            }
            if (i > 1 && i < paStr.length() - 1 && paStr.substring(i - 1).toLowerCase().startsWith("n") && i < paStr.length() - 1 && paStr.substring(i).startsWith("g") && !this.endsWithKnownWord(String.valueOf(paStrPreSyllables.toLowerCase()) + paStr.substring(0, i).toLowerCase())) {
                if (this.trace) {
                    System.out.println("ng wird nicht getrennt " + paStr.substring(i));
                }
                ++i;
                bCont = true;
                continue;
            }
            if (i > 0 && i < paStr.length() - 1 && AlgorithmHyphenator.isVocal(paStr.charAt(i + 1))) {
                if (!this.trace) continue;
                System.out.println("ein Vocal folgt sofort nach dem endenden Konsonant " + paStr.substring(i));
                continue;
            }
            if (i < paStr.length() && AlgorithmHyphenator.isConsonant(paStr.charAt(i))) {
                if (this.trace) {
                    System.out.println("Ende der Silbe mit Konsonant " + paStr.substring(i));
                }
                ++i;
                continue;
            }
            if (AlgorithmHyphenator.isAllConsonantes(paStr.substring(i))) {
                if (this.trace) {
                    System.out.println("es folgen nur noch Konsonanten bis zum Ende des Wortes " + paStr.substring(i));
                }
                i = paStr.length();
                continue;
            }
            if (!this.trace) continue;
            System.out.println("keine Regel hat gezogen");
        }
        String retStr = paStr.substring(0, i);
        if (bCkToKK) {
            retStr = String.valueOf(retStr.substring(0, retStr.length() - 1)) + "k";
        }
        return retStr;
    }

    public static boolean isConsonant(char paCh) {
        return !AlgorithmHyphenator.isVocal(paCh);
    }

    public static boolean isAllConsonantes(String paStr) {
        int i = 0;
        while (i < paStr.length()) {
            if (AlgorithmHyphenator.isVocal(paStr.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isVocal(char paCh) {
        return paCh == 'e' || paCh == 'a' || paCh == 'o' || paCh == 'u' || paCh == 'i' || paCh == '\ufffd' || paCh == '\ufffd' || paCh == '\ufffd' || paCh == 'E' || paCh == 'A' || paCh == 'O' || paCh == 'U' || paCh == 'I' || paCh == '\ufffd' || paCh == '\ufffd' || paCh == '\ufffd';
    }

    private boolean endsWithKnownWord(String paStr) {
        paStr = paStr.toLowerCase();
        Iterator<String> iter = this.knownWordHashSet.iterator();
        while (iter.hasNext()) {
            if (!paStr.endsWith(iter.next())) continue;
            return true;
        }
        return false;
    }

    private boolean checkKnownSyllable(String paStrLast, String paStrNext) {
        return this.endsWithKnownSyllable(paStrLast.toLowerCase()) && this.startsWithKnownSyllable(paStrNext);
    }

    private boolean endsWithKnownSyllable(String paStr) {
        Iterator<String> iter = this.syllHashSet.iterator();
        while (iter.hasNext()) {
            if (!paStr.endsWith(iter.next())) continue;
            return true;
        }
        return false;
    }

    private boolean startsWithKnownSyllable(String paStr) {
        Iterator<String> iter = this.syllHashSet.iterator();
        while (iter.hasNext()) {
            if (!paStr.startsWith(iter.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getComplicatedWordsFilename() {
        return "data/hyphenation/complicated_words_alg.txt";
    }
}

