/*
 * Decompiled with CFR 0.152.
 */
package document.text.spellcheck;

import com.stibocatalog.Hunspell;
import document.text.chunks.SpellingState;
import document.text.spellcheck.SpellTask;
import document.text.spellcheck.SpellTasks;
import gui.components.pageviewport.PageScrollPaneController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import init.App;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class Spellchecker
extends TimerTask {
    private static Spellchecker instance;
    private static Timer timer;
    private SpellTasks spellTasks = new SpellTasks();
    private boolean blockNextCheck = false;
    Hunspell.Dictionary dictionary;
    private Boolean mutex = new Boolean(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveDictionary() {
        Boolean bl = this.mutex;
        synchronized (bl) {
            if (this.dictionary == null && App.jnafound()) {
                Hunspell.Dictionary temp;
                try {
                    temp = Hunspell.getInstance().getDictionary("data/hunspell/dict/de_DE_neu/de_DE_neu");
                }
                catch (Exception ex) {
                    temp = null;
                }
                this.dictionary = temp;
            }
        }
    }

    public static Spellchecker getInstance() {
        if (instance == null) {
            instance = new Spellchecker();
            timer = new Timer("Spellcheck-Thread", true);
            timer.schedule((TimerTask)instance, 0L, 500L);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.blockNextCheck) {
            SpellTask spellTask = null;
            boolean workDone = false;
            do {
                SpellTasks spellTasks = this.spellTasks;
                synchronized (spellTasks) {
                    if (this.spellTasks.size() > 0) {
                        spellTask = (SpellTask)this.spellTasks.remove(0);
                        workDone = true;
                    } else {
                        spellTask = null;
                    }
                }
                if (spellTask == null) continue;
                this.doSpellTask(spellTask);
            } while (spellTask != null);
            if (workDone) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PageScrollPaneController spc = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController();
                        if (spc != null) {
                            PageViewPortController vpc = spc.getPageViewPortController();
                            vpc.addJobPaintActiveTextfield(false);
                        }
                    }
                });
            }
        } else {
            this.blockNextCheck = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSpellTask(SpellTask spellTask) {
        boolean isRight = false;
        this.retrieveDictionary();
        if (this.dictionary != null) {
            String word = spellTask.getWord();
            if (word.length() > 1) {
                char c = word.charAt(word.length() - 1);
                if (c == ',' || c == '.' || c == ';' || c == '?' || c == '!' || c == ')' || c == ':') {
                    word = word.substring(0, word.length() - 1);
                }
                if ((c = word.charAt(0)) == '(') {
                    word = word.substring(1);
                }
            }
            isRight = !this.dictionary.misspelled(word);
        } else {
            isRight = true;
        }
        SpellTasks spellTasks = this.spellTasks;
        synchronized (spellTasks) {
            if (isRight) {
                spellTask.getChunk().setSpellingState(SpellingState.correct);
            } else {
                spellTask.getChunk().setSpellingState(SpellingState.incorrect);
            }
        }
    }

    public SpellTasks getSpellTasks() {
        return this.spellTasks;
    }

    private boolean checkSpellDummy(String text) {
        boolean isRight = true;
        if (text.length() > 0) {
            switch (text.charAt(0)) {
                case 'a': {
                    isRight = false;
                }
                case 'e': {
                    isRight = false;
                    break;
                }
            }
        }
        return isRight;
    }

    public void setBlockNextCheck(boolean blockNextCheck) {
        this.blockNextCheck = blockNextCheck;
    }

    public Hunspell.Dictionary getDictionary() {
        this.retrieveDictionary();
        return this.dictionary;
    }
}

