/*
 * Decompiled with CFR 0.152.
 */
package gui.actions;

import document.MyDocument;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import util.io.IO;
import util.language.Lang;
import util.language.LanguageComponent;

public abstract class MyAction
extends AbstractAction
implements LanguageComponent {
    private static ArrayList<MyAction> actions = new ArrayList();
    private String deText;
    private String deTooltipText = "";
    protected JButton button = null;

    public MyAction(String name) {
        super(Lang.get(name));
        this.deText = name;
        Lang.registerComponent(this);
        actions.add(this);
    }

    public MyAction(String name, Icon icon) {
        super(Lang.get(name), icon);
        this.deText = name;
        Lang.registerComponent(this);
        actions.add(this);
    }

    public MyAction(String name, String imagePath) {
        this(name, MyAction.loadImage(imagePath));
        actions.add(this);
    }

    public void setCaption(String text) {
        this.deText = text;
        this.languageChanged();
    }

    public void setImage(String imagePath) {
        this.putValue("SmallIcon", MyAction.loadImage(imagePath));
    }

    public void setTooltip(String text) {
        this.deTooltipText = text;
        this.languageChanged();
    }

    @Override
    public void languageChanged() {
        this.putValue("Name", Lang.get(this.deText));
        if (this.deTooltipText.isEmpty()) {
            this.putValue("ShortDescription", "");
        } else {
            this.putValue("ShortDescription", Lang.get(this.deTooltipText));
        }
    }

    public static ImageIcon loadImage(String path) {
        ImageIcon image = null;
        try {
            image = new ImageIcon(IO.getDataFileURL(path));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public void setButton(JButton button) {
        this.button = button;
    }

    public JButton getButton() {
        return this.button;
    }

    public void setSelected(boolean b) {
        if (this.button != null) {
            this.button.setSelected(b);
        }
    }

    public MyDocument getActiveDocument() {
        return DocumentTabbedPaneController.getInstance().getActiveDocument();
    }

    protected abstract void dispose();

    public static void disposeAll() {
        for (MyAction action : actions) {
            action.dispose();
        }
        actions.clear();
    }
}

