/*
 * Decompiled with CFR 0.152.
 */
package gui.actions;

import document.MyDocument;
import document.view.MyView;
import gui.actions.AddQuickviewAction;
import gui.actions.MyAction;
import gui.actions.RemoveQuickviewAction;
import gui.components.mainpanel.MainPanelController;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.io.XMLFilter;
import util.xml.XMLReader;

public class OpenAction
extends MyAction {
    private static final long serialVersionUID = 1L;
    private static OpenAction instance;

    public static OpenAction getInstance() {
        if (instance == null) {
            instance = new OpenAction();
        }
        return instance;
    }

    private OpenAction() {
        super("\u00d6ffnen...", "data/img/menu/16/fileopen.png");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentTabbedPaneController dTPC = DocumentTabbedPaneController.getInstance();
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new XMLFilter());
        int returnVal = fc.showOpenDialog(MainPanelController.getInstance().getMainPanel());
        if (returnVal == 0) {
            try {
                File file = fc.getSelectedFile();
                String filepath = file.toURI().toASCIIString();
                Document doc = XMLReader.readFile(filepath);
                MyDocument document = new MyDocument();
                Element root = XMLReader.root(doc);
                document.deSerialize(root);
                document.setFilename(file.getAbsolutePath());
                document.setDirty(false);
                for (MyView view : document.views) {
                    dTPC.addView(view);
                }
                MainPanelController.getInstance().getMainPanel().setupToolbarsAccordingToToggleEditMode(true);
                RemoveQuickviewAction.getInstance().setEnabledStatus();
                AddQuickviewAction.getInstance().setEnabledStatus();
            }
            catch (Exception ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    protected void dispose() {
        instance = null;
    }
}

