/*
 * Decompiled with CFR 0.152.
 */
package gui.actions;

import document.MyDocument;
import gui.actions.MyAction;
import gui.components.pageviewport.PageViewPortController;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import renderer.g2dRenderer.PrintRenderer;

public class PrintAction
extends MyAction {
    private static final long serialVersionUID = 1L;
    private static PrintAction instance;

    public static PrintAction getInstance() {
        if (instance == null) {
            instance = new PrintAction();
        }
        return instance;
    }

    private PrintAction() {
        super("Drucken...", "data/img/menu/16/fileprint.png");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PageViewPortController controller = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
        MyDocument document = controller.getDocument();
        PrintRenderer printRenderer = new PrintRenderer(document);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setJobName("Testsheet");
        printerJob.setCopies(1);
        PageFormat format = printerJob.defaultPage();
        Paper paper = format.getPaper();
        double x = paper.getImageableX();
        double y = paper.getImageableY();
        double height = paper.getImageableHeight();
        double width = paper.getImageableWidth();
        height = paper.getHeight();
        width = paper.getWidth();
        x = 0.0;
        y = 0.0;
        paper.setImageableArea(x, y, width, height);
        format.setPaper(paper);
        printerJob.setPrintable(printRenderer, format);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Exception ex) {
                System.out.println("Print error: " + ex);
            }
        }
    }

    @Override
    protected void dispose() {
        instance = null;
    }
}

