/*
 * Decompiled with CFR 0.152.
 */
package gui.actions;

import document.MyDocument;
import gui.actions.MyAction;
import gui.components.mainpanel.MainPanelController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.io.XMLFilter;
import util.xml.XMLWriter;

public class SaveAction
extends MyAction {
    private static SaveAction instance;

    public static SaveAction getInstance() {
        if (instance == null) {
            instance = new SaveAction();
        }
        return instance;
    }

    private SaveAction() {
        super("Speichern", "data/img/menu/16/filesaveas.png");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PageViewPortController controller = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
        MainPanelController.getInstance().saveCurrentEventScript();
        MyDocument document = controller.getDocument();
        File file = null;
        if (!document.getFilename().isEmpty()) {
            file = new File(document.getFilename());
        } else {
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(new XMLFilter());
            int returnVal = fc.showSaveDialog(MainPanelController.getInstance().getMainPanel());
            if (returnVal == 0) {
                file = fc.getSelectedFile();
            }
        }
        if (file != null) {
            try {
                if (!file.getName().endsWith(".xml")) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + ".xml");
                }
                Document doc = XMLWriter.createEmptyDocument();
                Element element = doc.createElement("document");
                doc.appendChild(element);
                document.serialize(element);
                XMLWriter.writeToFile(doc, file);
                document.setFilename(file.getAbsolutePath());
                document.setDirty(false);
            }
            catch (Exception ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    protected void dispose() {
        instance = null;
    }
}

