/*
 * Decompiled with CFR 0.152.
 */
package gui.actions;

import gui.actions.MyAction;
import gui.components.mainpanel.MainPanel;
import gui.components.mainpanel.MainPanelController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import init.Settings;
import java.awt.event.ActionEvent;

public class ToggleEditModusAction
extends MyAction {
    private static ToggleEditModusAction instance;

    public static ToggleEditModusAction getInstance() {
        if (instance == null) {
            instance = new ToggleEditModusAction();
        }
        return instance;
    }

    private ToggleEditModusAction() {
        super("Bearbeitungsmodus", "data/img/menu/16/lock_open.png");
        this.setState();
    }

    private void setState() {
        switch (Settings.getInstance().getToggleEditModus()) {
            case edit: {
                this.setImage("data/img/menu/16/lock_open.png");
                this.setTooltip("Bearbeiten ist uneingeschr\u00e4nkt m\u00f6glich.");
                break;
            }
            case fillIn: {
                this.setImage("data/img/menu/16/lock.png");
                this.setTooltip("Bearbeiten nur in freigegebenen Feldern m\u00f6glich.");
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MainPanel mainPanel = MainPanelController.getInstance().getMainPanel();
        Settings.ToggleEditModus editmode = Settings.getInstance().getToggleEditModus();
        switch (editmode) {
            case edit: {
                Settings.getInstance().setToggleEditModus(Settings.ToggleEditModus.fillIn);
                mainPanel.setupToolbars(true, false, true, true, true);
                break;
            }
            case fillIn: {
                Settings.getInstance().setToggleEditModus(Settings.ToggleEditModus.edit);
                mainPanel.setupToolbars(true, true, true, true, false);
                break;
            }
        }
        this.setState();
        PageViewPortController controller = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
        editmode = Settings.getInstance().getToggleEditModus();
        controller.viewPortResized();
        controller.doRepaint();
    }

    @Override
    protected void dispose() {
        instance = null;
    }
}

