/*
 * Decompiled with CFR 0.152.
 */
package gui.actions.usermode;

import data.localdatabase.DBExchangeObject;
import data.localdatabase.DataProvider;
import gui.actions.MyAction;
import gui.components.mainpanel.MainPanelController;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.io.XMLFilter;
import util.xml.XMLReader;

public class OpenActionUserMode
extends MyAction {
    private static final long serialVersionUID = 1L;
    private static OpenActionUserMode instance;

    public static OpenActionUserMode getInstance() {
        if (instance == null) {
            instance = new OpenActionUserMode();
        }
        return instance;
    }

    private OpenActionUserMode() {
        super("Datendatei \u00d6ffnen ...", "data/img/menu/16/fileopen.png");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new XMLFilter());
        int returnVal = fc.showOpenDialog(MainPanelController.getInstance().getMainPanel());
        if (returnVal == 0) {
            try {
                try {
                    File file = fc.getSelectedFile();
                    String filepath = file.toURI().toASCIIString();
                    Document doc = XMLReader.readFile(filepath);
                    Element root = XMLReader.root(doc);
                    Element exchangeElement = XMLReader.element(root, "Exchange");
                    if (exchangeElement != null) {
                        MainPanelController.getInstance().getMainPanel().setCursor(Cursor.getPredefinedCursor(3));
                        DataProvider dp = MainPanelController.getInstance().getDataProvider();
                        DBExchangeObject dbeo = dp.getExchangeObject();
                        dbeo.deserialize(exchangeElement);
                        MainPanelController.getInstance().getPupilPanel().setDataProvidedStatus();
                        MainPanelController.getInstance().getMainPanel().setupToolbarsAccordingToToggleEditMode(MainPanelController.getInstance().getPupilPanel().isDataProvided());
                        MainPanelController.getInstance().getPupilPanel().selectPupilRow(0);
                        dp.setFilename(file.getAbsolutePath());
                        MainPanelController.getInstance().setDataProviderDirty(false);
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex);
                    ex.printStackTrace();
                }
            }
            finally {
                MainPanelController.getInstance().getMainPanel().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    @Override
    protected void dispose() {
        instance = null;
    }
}

