/*
 * Decompiled with CFR 0.152.
 */
package gui.components.mainmenu;

import gui.actions.LoadImageAction;
import gui.actions.NewDocumentAction;
import gui.actions.OpenAction;
import gui.actions.PrintAction;
import gui.actions.SaveAction;
import gui.actions.SaveAsAction;
import gui.actions.SaveAsPdfAction;
import gui.actions.editgroupzorder.CopyAction;
import gui.actions.editgroupzorder.CutAction;
import gui.actions.editgroupzorder.PasteAction;
import gui.actions.usermode.OpenActionUserMode;
import gui.actions.usermode.SaveActionUserMode;
import gui.actions.usermode.SaveAsActionUserMode;
import gui.components.mainframe.LanguageChangeListener;
import gui.components.mainmenu.MyJMenu;
import gui.components.mainmenu.MyJMenuItem;
import init.Settings;
import java.util.List;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import util.language.Lang;
import util.language.LangInfo;
import util.language.LanguageComponent;

public class MenuBar
extends JMenuBar
implements LanguageComponent {
    private static final long serialVersionUID = -3150544900100883283L;

    public MenuBar() {
        MyJMenu menuDatei = new MyJMenu("Datei");
        MyJMenu menuEdit = new MyJMenu("Bearbeiten");
        MyJMenu menuSprache = new MyJMenu("Sprache");
        List<LangInfo> languages = LangInfo.getAvailableLanguages();
        for (LangInfo language : languages) {
            MyJMenuItem mi = new MyJMenuItem(language.getLocalName(), language.getFlag16());
            mi.addActionListener(new LanguageChangeListener(language.getID()));
            menuSprache.add(mi);
        }
        boolean isEditMode = Settings.getInstance().isEditMode();
        if (isEditMode) {
            menuDatei.add(new JMenuItem(NewDocumentAction.getInstance()));
            menuDatei.add(new JMenuItem(OpenAction.getInstance()));
            menuDatei.add(new JMenuItem(SaveAction.getInstance()));
            menuDatei.add(new JMenuItem(SaveAsAction.getInstance()));
            menuDatei.addSeparator();
            menuDatei.add(new JMenuItem(PrintAction.getInstance()));
            menuDatei.add(new JMenuItem(SaveAsPdfAction.getInstance()));
        } else {
            menuDatei.add(new JMenuItem(SaveActionUserMode.getInstance()));
            menuDatei.add(new JMenuItem(SaveAsActionUserMode.getInstance()));
            menuDatei.add(new JMenuItem(OpenActionUserMode.getInstance()));
        }
        menuEdit.add(new JMenuItem(CopyAction.getInstance()));
        menuEdit.add(new JMenuItem(CutAction.getInstance()));
        menuEdit.add(new JMenuItem(PasteAction.getInstance()));
        menuEdit.addSeparator();
        if (isEditMode) {
            menuEdit.add(new JMenuItem(LoadImageAction.getInstance()));
        }
        this.add(menuDatei);
        this.add(menuEdit);
        this.add(menuSprache);
        Lang.registerComponent(this);
    }

    @Override
    public void languageChanged() {
    }
}

