/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.graphiccontext;

import document.text.TextStyle;
import gui.components.pageviewport.graphiccontext.LineMetricsCm;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public abstract class GraphicContext
extends Graphics2D {
    protected CoordinateSystem coordinateSystem = CoordinateSystem.panel;
    protected Graphics2D g2d;
    protected FontRenderContext frc;
    protected Font font300Dpi;
    private Rectangle2D boundsRect2D;
    protected static float factorCmProPixel300dpi = 0.008466667f;

    public GraphicContext(Graphics2D g2d) {
        this.g2d = g2d;
        AffineTransform tx = new AffineTransform();
        tx.setToIdentity();
        this.frc = new FontRenderContext(tx, true, true);
        Font f = new Font("Arial", 0, 12);
        this.setFont(f);
    }

    public abstract void setObjectMetrics(double var1, double var3, double var5, double var7, double var9);

    public Rectangle2D getStringBounds(String str, int beginIndex, int limit) {
        TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
        Rectangle2D rect = layout.getBounds();
        Rectangle2D.Double cmRect = new Rectangle2D.Double(rect.getX() * (double)factorCmProPixel300dpi, rect.getY() * (double)factorCmProPixel300dpi, rect.getWidth() * (double)factorCmProPixel300dpi, rect.getHeight() * (double)factorCmProPixel300dpi);
        return cmRect;
    }

    public float getStringAdvance(String str, int beginIndex, int limit) {
        if ((str = str.substring(beginIndex, limit)).length() > 0) {
            TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
            return layout.getAdvance() * factorCmProPixel300dpi;
        }
        return 0.0f;
    }

    public float getStringAdvance(String str) {
        if (str.length() > 0) {
            TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
            return layout.getAdvance() * factorCmProPixel300dpi;
        }
        return 0.0f;
    }

    public Rectangle2D getStringBounds(String str) {
        TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
        Rectangle2D rect = layout.getBounds();
        Rectangle2D.Double cmRect = new Rectangle2D.Double(rect.getX() * (double)factorCmProPixel300dpi, rect.getY() * (double)factorCmProPixel300dpi, rect.getWidth() * (double)factorCmProPixel300dpi, rect.getHeight() * (double)factorCmProPixel300dpi);
        return cmRect;
    }

    public LineMetricsCm getLineMetrics(String str) {
        LineMetrics lm = this.font300Dpi.getLineMetrics(str, this.frc);
        return new LineMetricsCm(lm);
    }

    public float getAscent(String str) {
        TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
        return layout.getAscent() * factorCmProPixel300dpi;
    }

    public float getDescent(String str) {
        TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
        return layout.getDescent() * factorCmProPixel300dpi;
    }

    public float getLeading(String str) {
        TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
        return layout.getLeading() * factorCmProPixel300dpi;
    }

    public TextLayout getTextLayout(String str) {
        return new TextLayout(str, this.font300Dpi, this.frc);
    }

    public static float getCmFactor() {
        return factorCmProPixel300dpi;
    }

    public abstract double getDotsPerCm();

    public abstract double pixelToPageCm(int var1);

    public abstract int pageCmToPixel(double var1);

    public abstract void setPageCoordinates(boolean var1);

    public abstract void setObjectCoordinates();

    public Rectangle2D getBoundsRect2D() {
        return this.boundsRect2D;
    }

    protected void setBoundsRect2D(Rectangle2D boundsRect2D) {
        this.boundsRect2D = boundsRect2D;
    }

    public abstract boolean isPrinter();

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.g2d.addRenderingHints(hints);
    }

    @Override
    public void clip(Shape s) {
        this.g2d.clip(s);
    }

    @Override
    public void draw(Shape s) {
        this.g2d.draw(s);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.g2d.drawGlyphVector(g, x, y);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        this.g2d.drawImage(img, xform, obs);
        return false;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.g2d.drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.g2d.drawRenderableImage(img, xform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.g2d.drawRenderedImage(img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public abstract void drawString(String var1, float var2, float var3);

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.g2d.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.g2d.drawString(iterator, x, y);
    }

    @Override
    public void fill(Shape s) {
        this.g2d.fill(s);
    }

    @Override
    public Color getBackground() {
        return this.g2d.getBackground();
    }

    @Override
    public Composite getComposite() {
        return this.g2d.getComposite();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.g2d.getDeviceConfiguration();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.g2d.getFontRenderContext();
    }

    @Override
    public Paint getPaint() {
        return this.g2d.getPaint();
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.g2d.getRenderingHint(hintKey);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.g2d.getRenderingHints();
    }

    @Override
    public Stroke getStroke() {
        return this.g2d.getStroke();
    }

    @Override
    public AffineTransform getTransform() {
        return this.g2d.getTransform();
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.g2d.hit(rect, s, onStroke);
    }

    @Override
    public void rotate(double theta) {
        this.g2d.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.g2d.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.g2d.scale(sx, sy);
    }

    @Override
    public void setBackground(Color color) {
        this.g2d.setBackground(color);
    }

    @Override
    public void setComposite(Composite comp) {
        this.g2d.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.g2d.setPaint(paint);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.g2d.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.g2d.setRenderingHints(hints);
    }

    @Override
    public void setStroke(Stroke s) {
        this.g2d.setStroke(s);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.g2d.setTransform(Tx);
    }

    @Override
    public void shear(double shx, double shy) {
        this.g2d.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.g2d.transform(Tx);
    }

    @Override
    public void translate(int x, int y) {
        this.g2d.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.g2d.translate(tx, ty);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.g2d.clearRect(x, y, width, height);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.g2d.clipRect(x, y, width, height);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.g2d.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public Graphics create() {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g2d.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.g2d.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.g2d.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.g2d.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.g2d.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.g2d.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.g2d.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g2d.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.g2d.drawOval(x, y, width, height);
    }

    @Override
    public void drawPolygon(int[] points, int[] points2, int points3) {
        this.g2d.drawPolygon(points, points2, points3);
    }

    @Override
    public void drawPolyline(int[] points, int[] points2, int points3) {
        this.g2d.drawPolyline(points, points2, points3);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g2d.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g2d.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.g2d.fillOval(x, y, width, height);
    }

    @Override
    public void fillPolygon(int[] points, int[] points2, int points3) {
        this.g2d.fillPolygon(points, points2, points3);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.g2d.fillRect(x, y, width, height);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g2d.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public Shape getClip() {
        return this.g2d.getClip();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.g2d.getClipBounds();
    }

    @Override
    public Color getColor() {
        return this.g2d.getColor();
    }

    @Override
    public Font getFont() {
        return this.g2d.getFont();
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.g2d.getFontMetrics(f);
    }

    @Override
    public void setClip(Shape clip) {
        this.g2d.setClip(clip);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.g2d.setClip(x, y, width, height);
    }

    @Override
    public void setColor(Color c) {
        this.g2d.setColor(c);
    }

    public void setFont(TextStyle textStyle) {
        AffineTransform at = new AffineTransform();
        at.setToIdentity();
        double factor = 4.166666666666666;
        at.scale(factor, factor);
        this.font300Dpi = textStyle.getFont().deriveFont(at);
        this.g2d.setFont(textStyle.getFont());
    }

    @Override
    public void setFont(Font font) {
        AffineTransform at = new AffineTransform();
        at.setToIdentity();
        double factor = 4.166666666666666;
        at.scale(factor, factor);
        this.font300Dpi = font.deriveFont(at);
        this.g2d.setFont(font);
    }

    @Override
    public void setPaintMode() {
        this.g2d.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.g2d.setXORMode(c1);
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public abstract void setPageCoordinates();

    public static enum CoordinateSystem {
        panel,
        page,
        object;

    }
}

