/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.ruler;

import document.view.ArtificialLine;
import document.view.ArtificialLines;
import document.view.Borders;
import gui.components.mainpanel.MainPanelController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.ruler.RulerInfo;
import gui.components.pageviewport.ruler.RulerMarkSource;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import init.Settings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import javax.swing.JComponent;
import util.graphics.CustomCursors;

public class Ruler
extends JComponent
implements MouseListener,
MouseMotionListener {
    public static final int width = 22;
    static final double[] cmPerNumberSuggestion = new double[]{0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0};
    private RulerInfo rulerInfo;
    private RulerInfo.Direction direction;
    private PageViewPortController controller;
    private ArrayList<RulerMarkSource> rulerMarkSources = new ArrayList();
    private MarkInfo draggedMark = null;

    public Ruler(RulerInfo rulerInfo, RulerInfo.Direction rulerDirection, PageViewPortController controller) {
        this.rulerInfo = rulerInfo;
        this.direction = rulerDirection;
        this.controller = controller;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setPreferredHeight(int ph) {
        this.setPreferredSize(new Dimension(22, ph));
    }

    public void setPreferredWidth(int pw) {
        this.setPreferredSize(new Dimension(pw, 22));
    }

    @Override
    protected void paintComponent(Graphics g) {
        float toBorder;
        float fromBorder;
        int to;
        int from;
        int height;
        int width;
        int y;
        int x;
        super.paintComponent(g);
        Rectangle clipRect = g.getClipBounds();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(SystemColor.control);
        g2d.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        g2d.setColor(Color.gray);
        if (this.direction == RulerInfo.Direction.horizontal) {
            x = clipRect.x;
            y = 6;
            width = clipRect.width;
            height = 10;
        } else {
            x = 6;
            width = 10;
            y = clipRect.y;
            height = clipRect.height;
        }
        g2d.fillRect(x, y, width, height);
        switch (this.direction) {
            case horizontal: {
                from = clipRect.x;
                to = clipRect.x + (int)clipRect.getWidth();
                break;
            }
            case vertical: {
                from = clipRect.y;
                to = clipRect.y + (int)clipRect.getHeight();
                break;
            }
            default: {
                from = 0;
                to = 0;
            }
        }
        AffineTransform oldTransForm = g2d.getTransform();
        int horVertFactor = 1;
        if (this.direction == RulerInfo.Direction.vertical) {
            g2d.rotate(-1.5707963267948966);
            horVertFactor = -1;
        }
        RulerInfo.PageRulerIterator priterator = this.rulerInfo.getIterator(from, to, this.direction);
        Borders borders = this.controller.getView().getBorders();
        float borderLeft = borders.getLeft();
        float borderRight = borders.getRight();
        float borderTop = borders.getTop();
        float borderBottom = borders.getBottom();
        if (this.direction == RulerInfo.Direction.horizontal) {
            fromBorder = borderLeft;
            toBorder = borderRight;
        } else {
            fromBorder = borderTop;
            toBorder = borderBottom;
        }
        while (priterator.hasNext()) {
            RulerInfo.PageRulerInfo pri = priterator.next();
            g2d.setColor(Color.white);
            int hfromPixel = pri.fromPixel + (int)((double)fromBorder * this.rulerInfo.getPixelPerCm());
            int toPixel = (int)((double)pri.fromPixel + (pri.lengthCm - (double)toBorder) * this.rulerInfo.getPixelPerCm());
            switch (this.direction) {
                case horizontal: {
                    g2d.fillRect(horVertFactor * hfromPixel, 6, toPixel - hfromPixel + 1, 10);
                    break;
                }
                case vertical: {
                    g2d.fillRect(-toPixel, 6, toPixel - hfromPixel, 10);
                    break;
                }
            }
            g2d.setFont(new Font("Arial", 0, 10));
            FontRenderContext frc = g2d.getFontRenderContext();
            int maxNumberWidth = (int)g2d.getFont().getStringBounds("19,9", frc).getWidth();
            int numberAscent = g2d.getFontMetrics().getAscent();
            if (maxNumberWidth <= 0) {
                maxNumberWidth = 1;
            }
            double cmPerNumber = 10.0;
            int i = 0;
            while (i < cmPerNumberSuggestion.length) {
                if (cmPerNumberSuggestion[i] * this.rulerInfo.getPixelPerCm() > (double)maxNumberWidth) {
                    cmPerNumber = cmPerNumberSuggestion[i];
                    break;
                }
                ++i;
            }
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.setColor(Color.black);
            float pos = 0.0f;
            while ((double)pos <= pri.lengthCm + 1.0E-6) {
                float posPixel = (float)((double)pri.fromPixel + (double)pos * this.rulerInfo.getPixelPerCm());
                String number = (double)Math.abs(pos - (float)((int)pos)) < 1.0E-6 ? Integer.toString((int)pos) : String.format("%1.1f", Float.valueOf(pos));
                float numberWidth = (float)g2d.getFont().getStringBounds(number, frc).getWidth();
                g2d.drawString(number, (float)horVertFactor * (posPixel - (float)horVertFactor * numberWidth / 2.0f), (float)(5 + numberAscent));
                Line2D.Float line = new Line2D.Float((float)horVertFactor * posPixel, 18.0f, (float)horVertFactor * posPixel, 22.0f);
                g2d.draw(line);
                pos = (float)((double)pos + cmPerNumber / 2.0);
                if ((double)pos <= pri.lengthCm + 1.0E-6) {
                    posPixel = (float)((double)pri.fromPixel + (double)pos * this.rulerInfo.getPixelPerCm());
                    line = new Line2D.Float((float)horVertFactor * posPixel, 9.0f, (float)horVertFactor * posPixel, 12.0f);
                    g2d.draw(line);
                }
                pos = (float)((double)pos + cmPerNumber / 2.0);
            }
            this.drawRulerMarks(g2d, pri);
        }
        g2d.setTransform(oldTransForm);
    }

    private void drawRulerMarks(Graphics2D g2d, RulerInfo.PageRulerInfo pri) {
        int horVertFactor = 1;
        if (this.direction == RulerInfo.Direction.vertical) {
            horVertFactor = -1;
        }
        RulerInfo.Direction rulerMarkDirection = this.getRulerMarkDirection();
        for (RulerMarkSource rms : this.rulerMarkSources) {
            int count = rms.getRulerMarkCount(rulerMarkDirection);
            int i = 0;
            while (i < count) {
                double position = rms.getRulerMarkPosition(rulerMarkDirection, i);
                int posPixelX = horVertFactor * (int)((float)pri.fromPixel + (float)(position * this.rulerInfo.getPixelPerCm()));
                int posPixelY = 22;
                rms.drawRulerMark(posPixelX, posPixelY, g2d);
                ++i;
            }
        }
    }

    public void setRulerInfo(RulerInfo rulerInfo) {
        this.rulerInfo = rulerInfo;
    }

    private float pixelToCm(int x, int y) {
        float ret = -1.0f;
        int pixelX = this.direction == RulerInfo.Direction.horizontal ? x : y;
        RulerInfo.PageRulerIterator priterator = this.rulerInfo.getIterator(0, pixelX + 10, this.direction);
        while (priterator.hasNext()) {
            RulerInfo.PageRulerInfo pri = priterator.next();
            if (pri.fromPixel >= pixelX || !((double)pri.fromPixel + pri.lengthCm * this.rulerInfo.getPixelPerCm() >= (double)pixelX)) continue;
            ret = (float)((double)(pixelX - pri.fromPixel) / this.rulerInfo.getPixelPerCm());
            break;
        }
        return ret;
    }

    private MarkInfo getMarkInfo(int x, int y) {
        MarkInfo ret = null;
        double pos = this.pixelToCm(x, y);
        int index = -1;
        double delta = 2.0 / this.rulerInfo.getPixelPerCm();
        RulerInfo.Direction rulerMarkDirection = this.getRulerMarkDirection();
        RulerMarkSource rulerMarkSourceFound = null;
        for (RulerMarkSource rms : this.rulerMarkSources) {
            index = rms.getRulerMarkIndex(rulerMarkDirection, pos, delta);
            if (index == -1) continue;
            rulerMarkSourceFound = rms;
            break;
        }
        if (index != -1) {
            ret = new MarkInfo();
            ret.rulerMarkSource = rulerMarkSourceFound;
            ret.index = index;
            ret.direction = rulerMarkDirection;
        }
        return ret;
    }

    private RulerInfo.Direction getRulerMarkDirection() {
        if (this.direction == RulerInfo.Direction.horizontal) {
            return RulerInfo.Direction.vertical;
        }
        return RulerInfo.Direction.horizontal;
    }

    public void addRulerMarkSource(RulerMarkSource rulerMarkSource) {
        this.rulerMarkSources.add(rulerMarkSource);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            MarkInfo mi;
            this.draggedMark = mi = this.getMarkInfo(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        double position = this.pixelToCm(e.getX(), e.getY());
        Cursor cursorNormal = Cursor.getDefaultCursor();
        MainPanelController.getInstance().getMainPanel().setCursor(cursorNormal);
        DocumentTabbedPaneController.getInstance().getTabbedPane().setCursor(cursorNormal);
        DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController().getPageViewport().setCursor(cursorNormal);
        if (e.getButton() == 1) {
            if (this.draggedMark != null) {
                int secondCoordinate = e.getX();
                if (this.direction == RulerInfo.Direction.horizontal) {
                    secondCoordinate = e.getY();
                }
                if (secondCoordinate >= 0 && secondCoordinate <= 20) {
                    position = this.snapToGrid(position);
                    this.draggedMark.rulerMarkSource.moveRulerMark(this.draggedMark.direction, this.draggedMark.index, position);
                } else {
                    this.draggedMark.rulerMarkSource.deleteRulerMark(this.draggedMark.direction, this.draggedMark.index);
                }
            } else {
                ArtificialLines afl = null;
                for (RulerMarkSource rms : this.rulerMarkSources) {
                    if (!(rms instanceof ArtificialLines)) continue;
                    afl = (ArtificialLines)rms;
                    break;
                }
                if (afl != null) {
                    position = this.snapToGrid(position);
                    afl.addArtificialLine(this.getRulerMarkDirection(), ArtificialLine.Origin.topleft, position);
                    this.setCursor(this.getCursorLeftRightUpDown());
                }
            }
            this.controller.doRepaint();
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.draggedMark != null) {
            int secondCoordinate = e.getX();
            if (this.direction == RulerInfo.Direction.horizontal) {
                secondCoordinate = e.getY();
            }
            if (secondCoordinate >= 0 && secondCoordinate <= 20 || this.draggedMark.rulerMarkSource instanceof Borders) {
                this.setCursor(this.getCursorLeftRightUpDown());
            } else {
                Cursor cursorX = CustomCursors.getCursor(CustomCursors.CURSOR_X);
                this.setCursor(cursorX);
                MainPanelController.getInstance().getMainPanel().setCursor(cursorX);
                DocumentTabbedPaneController.getInstance().getTabbedPane().setCursor(cursorX);
                DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController().getPageViewport().setCursor(cursorX);
            }
            double position = this.pixelToCm(e.getX(), e.getY());
            position = this.snapToGrid(position);
            this.draggedMark.rulerMarkSource.moveRulerMark(this.draggedMark.direction, this.draggedMark.index, position);
            this.controller.doRepaint();
            this.repaint();
        }
    }

    public double snapToGrid(double position) {
        if (Settings.getInstance().isSnapToGrid()) {
            if (this.direction == RulerInfo.Direction.horizontal) {
                return this.controller.getView().getGrid().getNextXPositionOnGrid(position);
            }
            return this.controller.getView().getGrid().getNextYPositoinOnGrid(position);
        }
        return position;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) == 0) {
            if (this.getMarkInfo(e.getX(), e.getY()) != null) {
                this.setCursor(this.getCursorLeftRightUpDown());
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private Cursor getCursorLeftRightUpDown() {
        if (this.direction == RulerInfo.Direction.horizontal) {
            return CustomCursors.getCursor(CustomCursors.CURSOR_LEFT_RIGHT);
        }
        return CustomCursors.getCursor(CustomCursors.CURSOR_UP_DOWN);
    }

    class MarkInfo {
        RulerMarkSource rulerMarkSource;
        RulerInfo.Direction direction;
        int index;

        MarkInfo() {
        }
    }
}

