/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.states;

import commands.deleteobjectscommand.DeleteObjectsCommand;
import document.AbstractKeyboardFocusable;
import document.MyObject;
import document.text.MyTextField;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.AbstractState;
import gui.components.pageviewport.states.StateLeftDownBeforeDrawingSelectionRectangle;
import gui.components.pageviewport.states.StateLeftDownOnHandle;
import gui.components.pageviewport.states.StateLeftDownOnObject;
import gui.components.pageviewport.states.StateLeftDownOnTextfield;
import gui.components.pageviewport.states.StateRightDownOnHandle;
import gui.components.pageviewport.states.StateRightDownOnObject;
import gui.components.pageviewport.states.StateRightDownOnPageBackground;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.pageviewport.states.data.MouseDocumentInfo;
import init.Settings;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import util.math.PointDouble;
import util.math.PointInt;

public class StateIdle
extends AbstractState {
    private PageViewPortController controller;
    private static StateIdle instance;

    private StateIdle(PageViewPortController controller) {
        this.controller = controller;
    }

    public static AbstractState enter(PageViewPortController controller) {
        controller.clearAllSnapPositions();
        if (instance == null) {
            instance = new StateIdle(controller);
        }
        StateIdle.instance.controller = controller;
        return instance;
    }

    @Override
    public void ESCpressed() {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        AbstractKeyboardFocusable kf = stateInfo.getKeyboardFocusableObject();
        if (kf != null) {
            kf.ESCPressed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyboardpressed(KeyEvent e) {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        AbstractKeyboardFocusable kf = stateInfo.getKeyboardFocusableObject();
        if (kf != null) {
            AbstractKeyboardFocusable abstractKeyboardFocusable = kf;
            synchronized (abstractKeyboardFocusable) {
                kf.keyboardpressed(e, this.controller);
            }
        } else {
            switch (e.getKeyCode()) {
                case 127: {
                    DeleteObjectsCommand command = new DeleteObjectsCommand(stateInfo);
                    stateInfo.getHandlesOfMarkedObjects();
                    this.controller.addJobPaintAll();
                    this.controller.doRepaint();
                    this.controller.getPageViewport().setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
            }
        }
    }

    @Override
    public void mouseLeftDown(MouseEvent e, MouseDocumentInfo info) {
        boolean isEditingAllowed;
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        boolean bl = isEditingAllowed = Settings.getInstance().getToggleEditModus() == Settings.ToggleEditModus.edit;
        if (info.getHandle() != null) {
            if (isEditingAllowed || info.getHandle().getOriginalObject().getIsEditingAllowedInFillinModus() == MyObject.EditingAllowedInFillinModus.allowed) {
                this.controller.stateChanged(StateLeftDownOnHandle.enter(this.controller, new PointDouble(info.getXCm(), info.getYCm()), info.getHandle()));
            }
        } else {
            MyObject object = info.getObject();
            boolean linkPressed = false;
            boolean fillinModeAndLockedObject = false;
            if (object != null) {
                MyTextField mtf;
                if (object.getIsEditingAllowedInFillinModus() == MyObject.EditingAllowedInFillinModus.denied && !isEditingAllowed) {
                    fillinModeAndLockedObject = true;
                }
                if (object instanceof MyTextField && (linkPressed = (mtf = (MyTextField)object).isOverMenu(info.getPPage()))) {
                    mtf.mouseLeftDown(info.getPPage(), info.getPPanel(), e.isShiftDown(), this.controller);
                }
            }
            if (object != null && !fillinModeAndLockedObject && !linkPressed) {
                if (isEditingAllowed || object.getIsEditingAllowedInFillinModus() == MyObject.EditingAllowedInFillinModus.allowed) {
                    AbstractKeyboardFocusable kf = info.getKeyboardFocusableIfInsideText();
                    if (kf != null && (e.getModifiersEx() & 0x80) == 0) {
                        AbstractKeyboardFocusable skf = stateInfo.getKeyboardFocusableObject();
                        this.controller.getPageViewport().grabFocus();
                        if (kf != skf) {
                            stateInfo.setKeyboardFocusableObject(kf);
                        }
                        kf.mouseLeftDown(info.getPPage(), info.getPPanel(), e.isShiftDown(), this.controller);
                        this.controller.stateChanged(StateLeftDownOnTextfield.enter(this.controller, info.getPPage(), kf));
                    } else {
                        this.controller.getCursorController().setEnabled(false);
                        stateInfo.setKeyboardFocusableObject(null);
                        if (isEditingAllowed || object.getIsEditingAllowedInFillinModus() == MyObject.EditingAllowedInFillinModus.allowed && !(object instanceof AbstractKeyboardFocusable)) {
                            this.controller.stateChanged(StateLeftDownOnObject.enter(this.controller, new PointDouble(info.getXCm(), info.getYCm()), info.getObject()));
                        }
                    }
                }
            } else {
                this.controller.getCursorController().setEnabled(false);
                stateInfo.setKeyboardFocusableObject(null);
                if (info.getPage() != null) {
                    this.controller.stateChanged(StateLeftDownBeforeDrawingSelectionRectangle.enter(this.controller, info.getPPage(), info.getPage()));
                }
            }
        }
    }

    @Override
    public void mouseLeftUp(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseRightDown(MouseEvent e, MouseDocumentInfo info) {
        boolean isEditingAllowed;
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        boolean bl = isEditingAllowed = Settings.getInstance().getToggleEditModus() == Settings.ToggleEditModus.edit;
        if (info.getHandle() != null) {
            if (isEditingAllowed || info.getHandle().getOriginalObject().getIsEditingAllowedInFillinModus() == MyObject.EditingAllowedInFillinModus.allowed) {
                this.controller.stateChanged(StateRightDownOnHandle.enter(this.controller, new PointDouble(info.getXCm(), info.getYCm()), info.getHandle()));
            }
        } else if (info.getObject() != null) {
            MyObject object = info.getObject();
            if (isEditingAllowed || object.getIsEditingAllowedInFillinModus() == MyObject.EditingAllowedInFillinModus.allowed) {
                AbstractKeyboardFocusable kf = info.getKeyboardFocusableIfInsideText();
                if (kf != null && stateInfo.getKeyboardFocusableObject() == kf) {
                    AbstractKeyboardFocusable skf = stateInfo.getKeyboardFocusableObject();
                    if (kf != skf) {
                        stateInfo.setKeyboardFocusableObject(kf);
                    }
                    kf.mouseRightDown(info.getPPage(), e.isShiftDown(), this.controller);
                } else {
                    this.controller.getCursorController().setEnabled(false);
                    stateInfo.setKeyboardFocusableObject(null);
                    this.controller.stateChanged(StateRightDownOnObject.enter(this.controller, new PointDouble(info.getXCm(), info.getYCm()), info.getObject()));
                }
            }
        } else {
            this.controller.getCursorController().setEnabled(false);
            stateInfo.setKeyboardFocusableObject(null);
            if (isEditingAllowed) {
                this.controller.stateChanged(StateRightDownOnPageBackground.enter(this.controller, new PointDouble(info.getXCm(), info.getYCm())));
            }
        }
    }

    @Override
    public void mouseRightUp(MouseEvent e, MouseDocumentInfo info) {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        AbstractKeyboardFocusable kf = stateInfo.getKeyboardFocusableObject();
        if (kf != null && kf instanceof MyTextField) {
            kf.mouseRightUp(info.getPPage(), new PointInt(info.getX(), info.getY()), e.isShiftDown(), this.controller);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e, MouseDocumentInfo info) {
        boolean isEditingAllowed;
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        boolean bl = isEditingAllowed = Settings.getInstance().getToggleEditModus() == Settings.ToggleEditModus.edit;
        if (info.getHandle() != null) {
            if (isEditingAllowed || info.getHandle().getOriginalObject().getIsEditingAllowedInFillinModus() == MyObject.EditingAllowedInFillinModus.allowed) {
                this.controller.getPageViewport().setCursor(Cursor.getPredefinedCursor(12));
                stateInfo.setHighlightedHandle(info.getHandle());
            }
        } else {
            MyTextField tf;
            stateInfo.setHighlightedHandle(null);
            MyObject object = info.getObject();
            boolean isOverLink = false;
            if (object instanceof MyTextField && (isOverLink = (tf = (MyTextField)object).isOverMenu(info.getPPage()))) {
                this.controller.getPageViewport().setCursor(Cursor.getPredefinedCursor(12));
            }
            if (!isOverLink) {
                if (object != null && (isEditingAllowed || info.getObject().getIsEditingAllowedInFillinModus() == MyObject.EditingAllowedInFillinModus.allowed)) {
                    AbstractKeyboardFocusable kf = info.getKeyboardFocusableIfInsideText();
                    if (kf != null && (e.getModifiersEx() & 0x80) == 0) {
                        this.controller.getPageViewport().setCursor(kf.getTextCursor());
                        kf.mouseMoved(info.getPPage(), e, this.controller);
                    } else if (isEditingAllowed || object.getIsEditingAllowedInFillinModus() == MyObject.EditingAllowedInFillinModus.allowed && !(object instanceof AbstractKeyboardFocusable)) {
                        this.controller.getPageViewport().setCursor(Cursor.getPredefinedCursor(13));
                    }
                } else {
                    this.controller.getPageViewport().setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyTyped(KeyEvent e) {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        AbstractKeyboardFocusable kf = stateInfo.getKeyboardFocusableObject();
        if (kf != null) {
            if (e.getKeyChar() == '\t') {
                AbstractKeyboardFocusable newAkf = (e.getModifiersEx() & 0x40) != 0 ? kf.getPreviousTabObject() : kf.getNextTabObject();
                if (newAkf != null) {
                    stateInfo.setKeyboardFocusableObject(newAkf);
                }
            } else {
                AbstractKeyboardFocusable abstractKeyboardFocusable = kf;
                synchronized (abstractKeyboardFocusable) {
                    AbstractKeyboardFocusable newAkf;
                    if (kf.keyTyped(e, this.controller) && (newAkf = kf.getNextTabObject()) != null) {
                        stateInfo.setKeyboardFocusableObject(newAkf);
                    }
                }
            }
        }
    }
}

