/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.states;

import document.MyObject;
import document.MyPage;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.paintjobs.PaintJobDrawSelectionRectangle;
import gui.components.pageviewport.states.AbstractState;
import gui.components.pageviewport.states.StateIdle;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.pageviewport.states.data.MouseDocumentInfo;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import util.math.MyMath;
import util.math.PointDouble;
import util.math.RectangleDouble;

public class StateLeftDownDrawingSelectionRectangle
extends AbstractState {
    private PageViewPortController controller;
    private static StateLeftDownDrawingSelectionRectangle instance;
    private PointDouble positionButtonPressed;
    private MyPage page;

    private StateLeftDownDrawingSelectionRectangle(PageViewPortController controller) {
        this.controller = controller;
    }

    public static AbstractState enter(PageViewPortController controller, PointDouble positionButtonPressed, MyPage page) {
        if (instance == null) {
            instance = new StateLeftDownDrawingSelectionRectangle(controller);
        }
        StateLeftDownDrawingSelectionRectangle.instance.controller = controller;
        StateLeftDownDrawingSelectionRectangle.instance.positionButtonPressed = positionButtonPressed;
        StateLeftDownDrawingSelectionRectangle.instance.page = page;
        return instance;
    }

    @Override
    public void ESCpressed() {
        this.controller.addJobPaintAll();
        this.controller.doRepaint();
        this.controller.stateChanged(StateIdle.enter(this.controller));
    }

    @Override
    public void keyboardpressed(KeyEvent e) {
    }

    @Override
    public void mouseLeftDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseLeftUp(MouseEvent e, MouseDocumentInfo info) {
        this.ESCpressed();
    }

    @Override
    public void mouseMoved(MouseEvent e, MouseDocumentInfo info) {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        info.setPagePoint(this.controller.pixelToPageCm(info.getPPanel(), this.page));
        double x = MyMath.min(this.positionButtonPressed.x, info.getPPage().x);
        double y = MyMath.min(this.positionButtonPressed.y, info.getPPage().y);
        double width = Math.abs(this.positionButtonPressed.x - info.getPPage().x);
        double height = Math.abs(this.positionButtonPressed.y - info.getPPage().y);
        Rectangle2D.Double rectangle = new Rectangle2D.Double(x, y, width, height);
        if ((e.getModifiersEx() & 0x40) == 0) {
            stateInfo.clearMarkedObjects();
        }
        for (MyObject object : this.page.objects) {
            RectangleDouble box = object.getBoundingBox();
            if (!(box.getLeft() >= x) || !(box.getRight() <= x + width) || !(box.getTop() >= y) || !(box.getBottom() <= y + height)) continue;
            stateInfo.addMarkedObject(object);
        }
        stateInfo.getHandlesOfMarkedObjects();
        PaintJobDrawSelectionRectangle job = new PaintJobDrawSelectionRectangle(rectangle, this.page, this.controller);
        this.controller.getPageViewport().addJob(job);
        this.controller.doRepaint();
    }

    @Override
    public void mouseRightDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseRightUp(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

