/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.states;

import commands.DrawObjectCommand;
import document.MyObject;
import document.MyPage;
import gui.actions.MyAction;
import gui.components.pageviewport.PageController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.autoarrange.SnapInfo;
import gui.components.pageviewport.autoarrange.SnapPositions;
import gui.components.pageviewport.states.AbstractState;
import gui.components.pageviewport.states.LeftUpCallBack;
import gui.components.pageviewport.states.StateIdle;
import gui.components.pageviewport.states.data.MouseDocumentInfo;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import util.math.PointDouble;

public class StatePullDrawingRectangle
extends AbstractState
implements LeftUpCallBack {
    private PageViewPortController controller;
    private static StatePullDrawingRectangle instance;
    private PointDouble positionButtonPressed;
    private MyObject object;
    private MyAction action;
    private PointDouble pos = new PointDouble();

    private StatePullDrawingRectangle(PageViewPortController controller) {
        this.controller = controller;
    }

    public static AbstractState enter(PageViewPortController controller, PointDouble positionButtonPressed, MyObject object, MyAction action) {
        if (instance == null) {
            instance = new StatePullDrawingRectangle(controller);
        }
        StatePullDrawingRectangle.instance.controller = controller;
        StatePullDrawingRectangle.instance.positionButtonPressed = positionButtonPressed;
        StatePullDrawingRectangle.instance.object = object;
        StatePullDrawingRectangle.instance.action = action;
        return instance;
    }

    @Override
    public void ESCpressed() {
        this.controller.getStateInfo().setObjectToDraw(null);
        this.controller.doRepaint();
        this.action.setSelected(false);
        this.controller.getPageViewport().setCursor(Cursor.getPredefinedCursor(0));
        this.controller.stateChanged(StateIdle.enter(this.controller));
    }

    @Override
    public void keyboardpressed(KeyEvent e) {
    }

    @Override
    public void mouseLeftDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseLeftUp(MouseEvent e, MouseDocumentInfo info) {
        this.controller.addLeftUpCallBack(e, info, this);
        this.controller.doRepaint();
    }

    @Override
    public void mouseMoved(MouseEvent e, MouseDocumentInfo info) {
        this.changeObject(e, info);
        this.controller.addJobMouseMoveUpdate();
        this.controller.doRepaint();
    }

    @Override
    public void mouseRightDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseRightUp(MouseEvent e, MouseDocumentInfo info) {
    }

    private void changeObject(MouseEvent e, MouseDocumentInfo info) {
        MyPage page = this.object.getPage();
        info.setPagePoint(this.controller.pixelToPageCm(info.getPPanel(), page));
        this.pos = info.getPPage();
        if (page != null) {
            PageController pc = this.controller.getPageController(page);
            this.controller.setAllArtificialAndBorderLinesToInactive();
            SnapInfo snapInfo = new SnapInfo();
            this.controller.snapToGridAndArtificialLines(this.pos, this.pos, snapInfo);
            PointDouble posAfterArtificialLineGridSnap = this.pos.getCopy();
            SnapPositions snapPositions = pc.getSnapPositions();
            snapPositions.clearActivePositions();
            if (snapPositions.isEmpty()) {
                pc.renewSnapPositions(null);
            }
            double maxDistance = this.controller.getSnapDeltaCm();
            snapPositions.snapPoint(this.pos, this.pos, SnapPositions.Type.horizontal, maxDistance);
            snapPositions.snapPoint(this.pos, this.pos, SnapPositions.Type.vertical, maxDistance);
            if (snapInfo.xCoordinateGotSnapped) {
                this.pos.x = posAfterArtificialLineGridSnap.x;
            }
            if (snapInfo.yCoordinateGotSnapped) {
                this.pos.y = posAfterArtificialLineGridSnap.y;
            }
        }
        if (this.positionButtonPressed.distanceTo(info.getPPage()) > 1.0E-6) {
            double x = info.getPPage().getX();
            double y = info.getPPage().getY();
            double dx = x - this.positionButtonPressed.getX();
            double dy = y - this.positionButtonPressed.getY();
            if (e.isShiftDown() || this.object.isDrawOnlyQuadratic()) {
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = Math.abs(dy) > 1.0E-6 ? dy / Math.abs(dy) * Math.abs(dx) : dx;
                    y = this.positionButtonPressed.getY() + dy;
                } else {
                    dx = Math.abs(dy) > 1.0E-6 ? dx / Math.abs(dx) * Math.abs(dy) : dy;
                    x = this.positionButtonPressed.getX() + dx;
                }
            }
            PointDouble mid = e.isControlDown() ? this.positionButtonPressed.getCopy() : new PointDouble((this.positionButtonPressed.getX() + x) / 2.0, (this.positionButtonPressed.getY() + y) / 2.0);
            double width = Math.abs(x - mid.getX()) * 2.0;
            double height = Math.abs(y - mid.getY()) * 2.0;
            this.object.setMidX(mid.getX());
            this.object.setMidY(mid.getY());
            this.object.setHeight(height);
            this.object.setWidth(width);
        }
    }

    @Override
    public void leftUpCallBack(MouseEvent e, MouseDocumentInfo info) {
        this.controller.getStateInfo().setObjectToDraw(null);
        DrawObjectCommand command = new DrawObjectCommand(this.object, this.object.getPage(), info.getMarkedObjectsAndHandles());
        info.getMarkedObjectsAndHandles().addMarkedObject(this.object);
        info.getMarkedObjectsAndHandles().getHandlesOfMarkedObjects();
        this.controller.doRepaint();
        this.action.setSelected(false);
        this.controller.getPageViewport().setCursor(Cursor.getPredefinedCursor(0));
        this.controller.stateChanged(StateIdle.enter(this.controller));
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

