/*
 * Decompiled with CFR 0.152.
 */
package gui.components.tabbedpane;

import gui.components.tabbedpane.ButtonTabComponent;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class DocumentTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private DocumentTabbedPaneController controller;

    public DocumentTabbedPane(DocumentTabbedPaneController controller) {
        this.controller = controller;
        this.setFocusable(false);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        this.setTabComponentAt(index, new ButtonTabComponent(this));
    }

    @Override
    public void addTab(String title, Icon icon, Component component, String tip) {
        super.addTab(title, icon, component, tip);
        this.setTabComponentAt(this.getTabCount() - 1, new ButtonTabComponent(this));
    }

    @Override
    public void setTitleAt(int index, String title) {
        super.setTitleAt(index, title);
        ((ButtonTabComponent)this.getTabComponentAt(index)).refreshText();
    }

    @Override
    public void remove(int index) {
        this.controller.closeTab(index);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }
}

