/*
 * Decompiled with CFR 0.152.
 */
package gui.components.toolbars.colorchooser;

import commands.changelinestyles.ChangeLineAlphaCommand;
import commands.changelinestyles.ChangeLineColorCommand;
import document.MyGroup;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import gui.components.toolbars.colorchooser.ColorChooserListener;
import gui.components.toolbars.colorchooser.ColorChooserToolButton;
import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.JButton;

public class LineColorChooser
implements ColorChooserListener {
    private ColorChooserToolButton colorChooserToolButton = new ColorChooserToolButton("/data/img/menu/16/brush.png", new Rectangle(0, 12, 15, 3), this, "Ohne Rand");
    private boolean alphaAdjustInProgress = false;

    @Override
    public void colorPicked(Color c) {
        PageViewPortController controller = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
        MarkedObjectsAndHandles info = controller.getStateInfo();
        ChangeLineColorCommand command = new ChangeLineColorCommand(info, c, false);
        controller.doRepaint();
        this.colorChooserToolButton.setMainButtonColor(c, false);
        this.colorChooserToolButton.hidePopup();
    }

    public JButton getMainButton() {
        return this.colorChooserToolButton.getMainButton();
    }

    public JButton getChooseButton() {
        return this.colorChooserToolButton.getChooseButton();
    }

    @Override
    public void alphaChanged(int alpha, boolean valueIsAdjusting) {
        PageViewPortController controller = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
        MarkedObjectsAndHandles info = controller.getStateInfo();
        if (valueIsAdjusting) {
            if (!this.alphaAdjustInProgress) {
                this.alphaAdjustInProgress = true;
                info.getMarkedObjects().makePreview();
                controller.addJobChangeMarkedObjects();
            }
            MyGroup previewObject = (MyGroup)info.getMarkedObjects().getPreviewObject();
            previewObject.setLineAlpha(alpha);
            controller.addJobMouseMoveUpdate();
            controller.doRepaint();
        } else {
            this.alphaAdjustInProgress = false;
            info.getMarkedObjects().releasePreview();
            ChangeLineAlphaCommand command = new ChangeLineAlphaCommand(info, alpha);
            controller.doRepaint();
            this.colorChooserToolButton.hidePopup();
        }
    }

    @Override
    public void withoutColorPicked() {
        PageViewPortController controller = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
        MarkedObjectsAndHandles info = controller.getStateInfo();
        ChangeLineColorCommand command = new ChangeLineColorCommand(info, null, true);
        controller.doRepaint();
        this.colorChooserToolButton.setMainButtonColor(Color.black, true);
        this.colorChooserToolButton.hidePopup();
    }

    public void setEnabled(boolean isEnabled) {
        this.colorChooserToolButton.setEnabled(isEnabled);
    }
}

