/*
 * Decompiled with CFR 0.152.
 */
package gui.components.zoomfactor;

import gui.components.pageviewport.PageScrollPaneController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import gui.components.zoomfactor.ZoomFactor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import util.language.Lang;
import util.language.LanguageComponent;

public class ZoomfactorComboBox
extends JComboBox
implements LanguageComponent,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static ZoomfactorComboBox instance = null;

    public static ZoomfactorComboBox getInstance() {
        if (instance == null) {
            instance = new ZoomfactorComboBox();
        }
        return instance;
    }

    public ZoomfactorComboBox() {
        ZoomFactor.fillZoomfactorCombobox(this);
        this.setFocusable(false);
        this.setSelectedIndex(2);
        this.addActionListener(this);
        Lang.registerComponent(this);
    }

    @Override
    public void languageChanged() {
        this.removeActionListener(this);
        int index = this.getSelectedIndex();
        ZoomFactor.fillZoomfactorCombobox(this);
        this.setSelectedIndex(index);
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PageScrollPaneController spc = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController();
        PageViewPortController pvpc = spc.getPageViewPortController();
        int itemIndex = this.getSelectedIndex();
        ZoomFactor zf = new ZoomFactor(itemIndex);
        pvpc.setZoomfactor(zf);
    }

    public void setZoomFactor(ZoomFactor zf) {
        this.removeActionListener(this);
        this.setSelectedIndex(zf.getIndex());
        this.addActionListener(this);
    }
}

