/*
 * Decompiled with CFR 0.152.
 */
package gui.netbeansforms;

import commands.SetBorderOfViewCommand;
import commands.SetGridOfViewCommand;
import commands.SetPageHeightCommand;
import commands.SetPageWidthCommand;
import commands.baseclasses.AbstractCommand;
import document.MyPage;
import document.view.MyView;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import gui.nbcomponents.frames.AbstractViewPropertyEditorController;
import javax.swing.DefaultComboBoxModel;
import util.io.IO;

public class ViewPropertyEditorController
extends AbstractViewPropertyEditorController {
    private static ViewPropertyEditorController instance;
    private Float[] rasterInvisibleValues = new Float[]{Float.valueOf(0.1f), Float.valueOf(0.2f), Float.valueOf(0.25f), Float.valueOf(0.4f), Float.valueOf(0.5f), Float.valueOf(1.0f)};
    private Float[] rasterVisibleValues = new Float[]{Float.valueOf(0.1f), Float.valueOf(0.2f), Float.valueOf(0.25f), Float.valueOf(0.4f), Float.valueOf(0.5f), Float.valueOf(0.8f), Float.valueOf(1.0f), Float.valueOf(1.2f), Float.valueOf(1.5f), Float.valueOf(2.0f)};
    private MyView view;

    public static ViewPropertyEditorController getInstance() {
        if (instance == null) {
            instance = new ViewPropertyEditorController();
        }
        return instance;
    }

    public ViewPropertyEditorController() {
        this.getComboBoxRasterInvisible().setModel(new DefaultComboBoxModel<Float>(this.rasterInvisibleValues));
        this.getComboBoxRasterVisible().setModel(new DefaultComboBoxModel<Float>(this.rasterVisibleValues));
        this.propertyEditor.setIconImage(IO.loadImage("data/img/menu/16/edit_properties.png").getImage());
    }

    public void showPropertyEditor(MyView view) {
        this.view = view;
        this.getComboBoxRasterInvisible().setSelectedIndex(this.getIndexFromArray(view.getGrid().getDelta(), this.rasterInvisibleValues));
        this.getComboBoxRasterVisible().setSelectedIndex(this.getIndexFromArray(view.getGrid().getVisibleDelta(), this.rasterVisibleValues));
        this.getUnitSpinnerBorderBottom().setValue(Float.valueOf(view.getBorders().getBottom()));
        this.getUnitSpinnerBorderLeft().setValue(Float.valueOf(view.getBorders().getLeft()));
        this.getUnitSpinnerBorderRight().setValue(Float.valueOf(view.getBorders().getRight()));
        this.getUnitSpinnerBorderTop().setValue(Float.valueOf(view.getBorders().getTop()));
        if (view.isAutomaticZoomToFitPage()) {
            MyPage page = view.getPage(0);
            this.getUnitSpinnerBreite().setValue(page.getWidthcm());
            this.getUnitSpinnerHoehe().setValue(page.getHeightcm());
        }
        super.showPropertyEditor(view.isAutomaticZoomToFitPage());
    }

    private int getIndexFromArray(float value, Float[] array) {
        int ret = 0;
        int i = 0;
        while (i < array.length) {
            Float f = array[i];
            if ((double)Math.abs(f.floatValue() - value) < 1.0E-6) {
                ret = i;
                break;
            }
            ++i;
        }
        return ret;
    }

    @Override
    public void buttonOKActionPerformed() {
        float newInvisibleDelta;
        float newVisibleDelta;
        int factor;
        SetBorderOfViewCommand setBorderOfViewCommand;
        float value = ((Number)this.getUnitSpinnerBorderBottom().getValue()).floatValue();
        if ((double)Math.abs(value - this.view.getBorders().getBottom()) > 1.0E-6) {
            setBorderOfViewCommand = new SetBorderOfViewCommand(SetBorderOfViewCommand.BorderLocation.bottom, value, this.view);
        }
        if ((double)Math.abs((value = ((Number)this.getUnitSpinnerBorderTop().getValue()).floatValue()) - this.view.getBorders().getTop()) > 1.0E-6) {
            setBorderOfViewCommand = new SetBorderOfViewCommand(SetBorderOfViewCommand.BorderLocation.top, value, this.view);
        }
        if ((double)Math.abs((value = ((Number)this.getUnitSpinnerBorderLeft().getValue()).floatValue()) - this.view.getBorders().getLeft()) > 1.0E-6) {
            setBorderOfViewCommand = new SetBorderOfViewCommand(SetBorderOfViewCommand.BorderLocation.left, value, this.view);
        }
        if ((double)Math.abs((value = ((Number)this.getUnitSpinnerBorderRight().getValue()).floatValue()) - this.view.getBorders().getRight()) > 1.0E-6) {
            setBorderOfViewCommand = new SetBorderOfViewCommand(SetBorderOfViewCommand.BorderLocation.right, value, this.view);
        }
        boolean setMetricsNeeded = false;
        if (this.view.isAutomaticZoomToFitPage()) {
            AbstractCommand cmd;
            MyPage page = this.view.getPage(0);
            value = ((Number)this.getUnitSpinnerBreite().getValue()).floatValue();
            if (Math.abs((double)value - page.getWidthcm()) > 1.0E-6) {
                cmd = new SetPageWidthCommand(value, page);
                setMetricsNeeded = true;
            }
            if (Math.abs((double)(value = ((Number)this.getUnitSpinnerHoehe().getValue()).floatValue()) - page.getHeightcm()) > 1.0E-6) {
                cmd = new SetPageHeightCommand(value, page);
                setMetricsNeeded = true;
            }
        }
        if ((factor = Math.round((newVisibleDelta = ((Float)this.getComboBoxRasterVisible().getSelectedItem()).floatValue()) / (newInvisibleDelta = ((Float)this.getComboBoxRasterInvisible().getSelectedItem()).floatValue()))) < 1) {
            factor = 1;
        }
        if ((double)Math.abs((newVisibleDelta = (float)factor * newInvisibleDelta) - this.view.getGrid().getVisibleDelta()) > 1.0E-6 || (double)Math.abs(newInvisibleDelta - this.view.getGrid().getDelta()) > 1.0E-6) {
            SetGridOfViewCommand setGridOfViewCommand = new SetGridOfViewCommand(newVisibleDelta, newInvisibleDelta, this.view);
        }
        this.propertyEditor.setVisible(false);
        DocumentTabbedPaneController dTPC = DocumentTabbedPaneController.getInstance();
        dTPC.getActivePageScrollPaneController().getPageScrollPane().repaint();
        if (setMetricsNeeded) {
            dTPC.getActivePageScrollPaneController().getPageViewPortController().setMetrics();
        }
    }
}

