/*
 * Decompiled with CFR 0.152.
 */
package renderer.g2dRenderer;

import document.MyDocument;
import document.MyPage;
import document.view.MyView;
import gui.components.pageviewport.graphiccontext.PrinterGraphicContext;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import renderer.g2dRenderer.G2dRenderer;

public class PrintRenderer
implements Printable {
    private MyDocument document;

    public PrintRenderer(MyDocument document) {
        this.document = document;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        MyView printView = this.document.getPrintView();
        if (printView != null) {
            if (pageIndex < printView.pages.size()) {
                MyPage page = printView.pages.get(pageIndex);
                double printPageWidthCm = pageFormat.getWidth() / 72.0 * 2.54;
                double dxCm = (printPageWidthCm - page.getWidthcm()) / 2.0;
                double dxPrintPoints = dxCm / 2.54 * 72.0;
                PrinterGraphicContext pgc = new PrinterGraphicContext(28.346456692913385, 1.0, (int)dxPrintPoints, 0, page.getWidthcm(), page.getHeightcm(), (Graphics2D)graphics);
                G2dRenderer renderer = new G2dRenderer(pgc);
                renderer.render(page, false);
                return 0;
            }
            return 1;
        }
        return 1;
    }
}

