/*
 * Decompiled with CFR 0.152.
 */
package util;

import gui.components.mainpanel.MainPanelController;
import javax.swing.JOptionPane;
import util.language.Lang;
import util.logging.Log;

public class AppError {
    public static final int WARNING = 0;
    public static final int FATAL = 1;

    public static void showError(int level, Exception ex) {
        if (level == 1) {
            try {
                Log.log(4, "Fatal error! Application must be closed!");
                Log.log(4, null, ex);
                Log.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AppError.showFatalErrorDialog(ex);
        } else if (level == 0) {
            AppError.showWarningDialog(ex.getMessage());
        }
    }

    public static void showError(int level, String message) {
        if (level == 1) {
            AppError.showError(level, new Exception(message));
        } else {
            AppError.showWarningDialog(message);
        }
    }

    private static void showFatalErrorDialog(Exception ex) {
        if (ex != null) {
            ex.printStackTrace();
        }
        JOptionPane.showMessageDialog(MainPanelController.getInstance().getMainPanel(), Lang.get("fatalerrordialog.message"), Lang.get("fatalerrordialog.title"), 0);
    }

    private static void showWarningDialog(String message) {
        Log.log(3, "Warning: " + message);
        JOptionPane.showMessageDialog(MainPanelController.getInstance().getMainPanel(), message, Lang.get("warningdialog.title"), 2);
    }
}

