/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FilenameFilter;

public class FileTools {
    private static FileFilter directoriesFilter = null;

    public static FileFilter getDirectoriesFilter() {
        if (directoriesFilter == null) {
            directoriesFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() && !file.getName().startsWith(".");
                }
            };
        }
        return directoriesFilter;
    }

    public static FilenameFilter getXMLFilter() {
        FilenameFilter ret = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        };
        return ret;
    }

    public static FilenameFilter getVocFilter() {
        FilenameFilter ret = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".voc");
            }
        };
        return ret;
    }

    public static FilenameFilter getTTFFilter() {
        FilenameFilter ret = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".ttf");
            }
        };
        return ret;
    }

    public static FilenameFilter getSVGFilter() {
        FilenameFilter ret = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".svg");
            }
        };
        return ret;
    }

    public static String readFile(File file) {
        try {
            StringBuffer fileData = new StringBuffer(1024);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            reader.close();
            return fileData.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getNameWithoutExt(File file) {
        String fileName = file.getName();
        int dotPos = fileName.indexOf(".", 1);
        if (dotPos == -1) {
            return fileName;
        }
        return fileName.substring(0, dotPos);
    }
}

