/*
 * Decompiled with CFR 0.152.
 */
package util.fontmanager;

import init.Settings;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import util.FileTools;
import util.fontmanager.MachineIndependentFont;
import util.io.IO;
import util.logging.Log;

public class FontManager {
    ArrayList<MachineIndependentFont> machineIndependentFonts = new ArrayList();
    private static FontManager instance;
    private static boolean isLinux;
    private static final String defaultFontPath = "data/fonts";
    private static String[] userFontNames;
    private static String[] linuxFontNames;
    private static String[] windowsFontNames;
    private static String[] pdfFontNames;

    static {
        userFontNames = new String[]{"ohne Serifen", "mit Serifen", "nichtproportional"};
        linuxFontNames = new String[]{"Liberation Sans", "Liberation Serif", "Liberation Mono"};
        windowsFontNames = new String[]{"Arial", "Times New Roman", "Courier"};
        pdfFontNames = new String[]{"Arial", "Serif", "Courier"};
    }

    public String[] getUserFontNames() {
        return userFontNames;
    }

    public String getScreenPrintFontName(String userFontName) {
        String fontName = "";
        fontName = isLinux ? this.getLinuxFontName(userFontName) : this.getWindowsFontName(userFontName);
        return fontName;
    }

    public String getLinuxFontName(String userFontName) {
        return linuxFontNames[this.getUserFontNameIndex(userFontName)];
    }

    public String getWindowsFontName(String userFontName) {
        return windowsFontNames[this.getUserFontNameIndex(userFontName)];
    }

    public String getPdfFontName(String userFontName) {
        return pdfFontNames[this.getUserFontNameIndex(userFontName)];
    }

    private int getUserFontNameIndex(String userFontName) {
        if (userFontName.length() > 0) {
            char ch = userFontName.charAt(0);
            switch (ch) {
                case 'o': {
                    return 0;
                }
                case 'm': {
                    return 1;
                }
                case 'n': {
                    return 2;
                }
            }
            return 0;
        }
        return 0;
    }

    public FontManager() {
        this.loadMachineIndependentFonts();
        String os = System.getProperty("os.name").toLowerCase();
        isLinux = !os.startsWith("windows");
    }

    public static FontManager getInstance() {
        if (instance == null) {
            instance = new FontManager();
        }
        return instance;
    }

    public void loadMachineIndependentFonts() {
        try {
            String[] fontFiles = IO.listDataFiles(defaultFontPath, FileTools.getTTFFilter());
            int iFiles = 0;
            while (iFiles < fontFiles.length) {
                String currentFile = "data/fonts/" + fontFiles[iFiles];
                Log.log(2, "Reading language file \"" + currentFile + "\"...");
                InputStream fontFile = IO.openDataFile(currentFile);
                Font font = Font.createFont(0, fontFile);
                this.machineIndependentFonts.add(new MachineIndependentFont(font));
                ++iFiles;
            }
        }
        catch (Exception e) {
            Log.log(2, "FontManager.loadMachineIndependentFonts: Couldn't open any machineindependent fonts.\n" + e.toString());
        }
        for (MachineIndependentFont mf : this.machineIndependentFonts) {
            if (mf.getStyle() == 0) continue;
            for (MachineIndependentFont mf1 : this.machineIndependentFonts) {
                if (!mf.getFont().getName().startsWith(mf1.getFont().getName())) continue;
                mf1.addDerivedFont(mf);
                mf.setDerivedFont(true);
            }
        }
        int i = 0;
        while (i < this.machineIndependentFonts.size()) {
            if (this.machineIndependentFonts.get(i).isDerivedFont()) {
                this.machineIndependentFonts.remove(i);
                continue;
            }
            ++i;
        }
    }

    public Font getFont(String name, int style, float size) {
        Font font = null;
        name = this.getScreenPrintFontName(name);
        for (MachineIndependentFont mf : this.machineIndependentFonts) {
            if (mf.getFont().getName().compareToIgnoreCase(name) != 0) continue;
            font = mf.derive(style, size);
            if (!Settings.getInstance().isKerning()) break;
            HashMap<TextAttribute, Integer> attributes = new HashMap<TextAttribute, Integer>();
            attributes.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
            attributes.put(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON);
            font = font.deriveFont(attributes);
            break;
        }
        if (font == null) {
            font = new Font(name, style, 1).deriveFont(style, size);
            if (Settings.getInstance().isKerning()) {
                HashMap<TextAttribute, Integer> attributes = new HashMap<TextAttribute, Integer>();
                attributes.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
                attributes.put(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON);
                font = font.deriveFont(attributes);
            }
        }
        return font;
    }

    public Font getPdfFont(String name, int style, float size) {
        Font font = null;
        name = this.getPdfFontName(name);
        font = new Font(name, style, 1).deriveFont(style, size);
        return font;
    }

    public String getFirstFont() {
        return userFontNames[0];
    }
}

