/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import util.io.IOInterface;

public class ApplicationIO
implements IOInterface {
    @Override
    public boolean existsDataFile(String filepath) {
        return new File(filepath).exists();
    }

    @Override
    public boolean existsDataDirectory(String directory) {
        File file = new File(directory);
        return file.exists() && file.isDirectory();
    }

    @Override
    public InputStream openDataFile(String filepath) throws IOException {
        return new FileInputStream(new File(filepath));
    }

    @Override
    public URL getDataFileURL(String filepath) throws IOException {
        URL url;
        if (filepath.length() == 0) {
            throw new IOException("Empty filepath is not allowed!");
        }
        if (filepath.charAt(0) != '/') {
            filepath = String.valueOf('/') + filepath;
        }
        if ((url = this.getClass().getResource(filepath)) == null) {
            throw new IOException("\"" + filepath + "\" not found!");
        }
        return url;
    }

    @Override
    public String[] listDataFiles(String directory) throws IOException {
        return this.listDataFiles(directory, null);
    }

    @Override
    public String[] listDataFiles(String directory, FilenameFilter filter) throws IOException {
        if (filter != null) {
            return new File(directory).list(filter);
        }
        return new File(directory).list();
    }

    @Override
    public ArrayList<String> listDirectory(String path) {
        File[] langs = new File(path).listFiles();
        ArrayList<String> list = new ArrayList<String>();
        File[] fileArray = langs;
        int n = langs.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            list.add(file.getName());
            ++n2;
        }
        return list;
    }
}

