/*
 * Decompiled with CFR 0.152.
 */
package util.language;

import init.App;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.AppError;
import util.FileTools;
import util.io.IO;
import util.language.LanguageComponent;
import util.logging.Log;
import util.xml.XMLReader;

public class Lang {
    private static final String defaultLangPath = "data/languages";
    private static String langPath = "data/languages";
    private static String currentLanguageID = "";
    private static Hashtable<String, String> entries = new Hashtable(1);
    private static ArrayList<LanguageComponent> languageComponents = new ArrayList();

    public static void loadLanguage(String id) {
        currentLanguageID = id;
        String currentFile = "";
        try {
            Log.log(2, "Loading language pack \"" + id + "\"...");
            String[] langFiles = IO.listDataFiles(String.valueOf(langPath) + "/" + id, FileTools.getVocFilter());
            if (langFiles == null) {
                if (id.equals("en")) {
                    AppError.showError(1, new Exception("Language pack \"" + id + "\" not found!"));
                } else {
                    Log.log(4, "Language pack \"" + id + "\" not found! Trying to load \"en\"...");
                    Lang.loadLanguage("en");
                }
            } else {
                entries = new Hashtable(100);
                int entriesCount = 0;
                int entriesOverwrittenCount = 0;
                int iFiles = 0;
                while (iFiles < langFiles.length) {
                    currentFile = new File(langFiles[iFiles]).getName();
                    Log.log(2, "Reading language file \"" + currentFile + "\"...");
                    Document doc = null;
                    doc = XMLReader.readFile(IO.openDataFile(String.valueOf(langPath) + "/" + id + "/" + currentFile));
                    Element root = XMLReader.root(doc);
                    List<Element> eEntries = XMLReader.elements(root, "voc");
                    int i = 0;
                    while (i < eEntries.size()) {
                        String oldValue;
                        Element e = eEntries.get(i);
                        String eID = XMLReader.attributeNotNull(e, "key");
                        String eValue = XMLReader.attributeNotNull(e, "value");
                        if (eValue.isEmpty()) {
                            eValue = eID;
                        }
                        if ((oldValue = entries.put(eID, eValue)) == null) {
                            ++entriesCount;
                        } else {
                            Log.log(3, "Overwritten entry: " + eID);
                            ++entriesOverwrittenCount;
                        }
                        ++i;
                    }
                    Log.log(2, "Language pack loaded. Entries: " + entriesCount + ". Overwritten entries: " + entriesOverwrittenCount);
                    ++iFiles;
                }
            }
            Lang.updateLanguageComponents();
        }
        catch (Exception ex) {
            Log.log(4, "Language pack \"" + id + "\" could not be loaded! " + "Reading file \"" + currentFile + "\" failed! Details:");
            AppError.showError(1, ex);
        }
    }

    public static String get(String id) {
        if (id == null) {
            return "";
        }
        String ret = entries.get(id);
        if (ret == null) {
            return id;
        }
        ret = ret.replace("\\n", "\n");
        ret = ret.replace("\\{app.name\\}", App.PROJECT_NAME);
        return ret;
    }

    public static String get(String id, String[] replacements) {
        String ret = Lang.get(id);
        if (replacements != null) {
            int i = 0;
            while (i < replacements.length) {
                ret = ret.replaceAll("\\{" + (i + 1) + "\\}", replacements[i]);
                ++i;
            }
        }
        return ret;
    }

    public static String getCurrentLanguageID() {
        return currentLanguageID;
    }

    public static String getLangPath() {
        return langPath;
    }

    public static void registerComponent(LanguageComponent component) {
        if (component != null) {
            languageComponents.add(component);
        }
    }

    public static void unregisterAllComponents() {
        languageComponents.clear();
    }

    public static void unregisterComponent(LanguageComponent component) {
        if (component != null) {
            languageComponents.remove(component);
        }
    }

    private static void updateLanguageComponents() {
        for (LanguageComponent component : languageComponents) {
            if (component == null) {
                languageComponents.remove(component);
                continue;
            }
            component.languageChanged();
        }
    }

    static void setLangPath(String langPath) {
        Lang.langPath = langPath == null ? defaultLangPath : langPath;
    }
}

