/*
 * Decompiled with CFR 0.152.
 */
package util.language;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.AppError;
import util.io.IO;
import util.language.Lang;
import util.logging.Log;
import util.xml.XMLReader;

public class LangInfo {
    private String id;
    private String localName;
    private String internationalName;
    private ImageIcon flag16;

    public LangInfo(String id) throws Exception {
        Document doc = XMLReader.readFile(IO.openDataFile(String.valueOf(Lang.getLangPath()) + "/" + id + "/info.xml"));
        Element root = XMLReader.root(doc);
        Element intName = XMLReader.element(root, "intname");
        Element localName = XMLReader.element(root, "localname");
        this.id = id;
        if (intName == null) {
            throw new Exception("intname must be set!");
        }
        this.internationalName = XMLReader.textTrim(intName);
        this.localName = localName != null ? XMLReader.textTrim(localName) : null;
        this.loadFlagImage();
    }

    public String getID() {
        return this.id;
    }

    public String getInternationalName() {
        return this.internationalName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public Icon getFlag16() {
        return this.flag16;
    }

    public static List<LangInfo> getAvailableLanguages() {
        ArrayList<LangInfo> ret = new ArrayList<LangInfo>();
        ArrayList<String> langs = IO.listDirectory(Lang.getLangPath());
        if (langs.size() == 0) {
            AppError.showError(1, new Exception("Languages directory does not exist!"));
        } else {
            for (String lang : langs) {
                try {
                    ret.add(new LangInfo(lang));
                }
                catch (Exception ex) {
                    Log.log(4, "Language pack \"" + lang + "\" could not be loaded!");
                }
            }
        }
        return ret;
    }

    private void loadFlagImage() {
        try {
            this.flag16 = new ImageIcon(IO.getDataFileURL(String.valueOf(Lang.getLangPath()) + "/" + this.id + "/flag16.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

