/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.baseclasses.AbstractCommand;
import document.MyImage;
import document.MyPage;
import gui.components.pageviewport.PageViewPortController;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import java.io.File;
import java.io.IOException;
import util.logging.Log;

public class InsertImageCommand
extends AbstractCommand {
    private MyPage page;
    private MyImage myImage;

    public InsertImageCommand(File file) {
        try {
            this.myImage = new MyImage();
            this.myImage.readImageFromFile(file);
            DocumentTabbedPaneController dTPC = DocumentTabbedPaneController.getInstance();
            PageViewPortController controller = dTPC.getActivePageScrollPaneController().getPageViewPortController();
            int index = (controller.getFirstVisiblePage() + controller.getLastVisiblePage()) / 2;
            this.page = controller.getView().getPage(index);
            this.page.getDocument().getCommandManager().invokeCommand(this);
        }
        catch (IOException ex) {
            Log.log(3, "InsertImageCommand: could not read Image from file.");
        }
    }

    @Override
    public final boolean doIt() {
        this.page.addObject(this.myImage);
        return true;
    }

    @Override
    public final boolean undoIt() {
        this.page.removeObject(this.myImage);
        DocumentTabbedPaneController dTPC = DocumentTabbedPaneController.getInstance();
        PageViewPortController controller = dTPC.getActivePageScrollPaneController().getPageViewPortController();
        controller.getStateInfo().removeMarkedObject(this.myImage);
        controller.getStateInfo().getHandlesOfMarkedObjects();
        return false;
    }
}

