/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.baseclasses.AbstractCommand;
import document.MyObject;
import document.MyPage;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import java.util.ArrayList;

public class MoveCommand
extends AbstractCommand {
    private MyPage oldPage;
    private MyPage newPage;
    private int[] indexesInOldPage;
    private double dx;
    private double dy;
    private ArrayList<MyObject> objectsToMove;
    private MarkedObjectsAndHandles stateInfo;
    private ArrayList<MyObject> oldMarkedObjects = new ArrayList();
    private boolean copyObjects;
    private ArrayList<MyObject> copiedObjects;

    public MoveCommand(MarkedObjectsAndHandles stateInfo, ArrayList<MyObject> objectsToMove, double dx, double dy, MyPage newPage, boolean copyObjects) {
        this.objectsToMove = objectsToMove;
        this.oldPage = stateInfo.getMarkedObjects().getPage();
        this.newPage = newPage;
        this.indexesInOldPage = new int[objectsToMove.size()];
        int i = 0;
        while (i <= objectsToMove.size() - 1) {
            MyObject object = objectsToMove.get(i);
            this.indexesInOldPage[i] = this.oldPage.objects.indexOf(object);
            ++i;
        }
        this.dx = dx;
        this.dy = dy;
        this.stateInfo = stateInfo;
        this.copyObjects = copyObjects;
        for (MyObject object : stateInfo.getMarkedObjects().getObjects()) {
            this.oldMarkedObjects.add(object);
        }
        if (copyObjects) {
            this.copiedObjects = new ArrayList();
            for (MyObject object : objectsToMove) {
                MyObject copy = object.getCopy();
                copy.move(dx, dy);
                this.copiedObjects.add(copy);
            }
        }
        this.oldPage.getDocument().getCommandManager().invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        this.stateInfo.getMarkedObjects().clear();
        int i = 0;
        while (i < this.oldPage.getObjects().size()) {
            MyObject object = this.oldPage.getObjects().get(i);
            if (this.objectsToMove.contains(object)) {
                if (this.copyObjects) {
                    int j = this.objectsToMove.indexOf(object);
                    MyObject newObject = this.copiedObjects.get(j);
                    this.newPage.addObject(this.copiedObjects.get(j));
                    this.stateInfo.getMarkedObjects().add(newObject);
                } else {
                    if (this.oldPage != this.newPage) {
                        this.oldPage.removeObject(object);
                        this.newPage.addObject(object);
                    }
                    object.move(this.dx, this.dy);
                    this.stateInfo.getMarkedObjects().add(object);
                }
            }
            ++i;
        }
        this.stateInfo.getMarkedObjects().setPage(this.newPage);
        return true;
    }

    @Override
    public final boolean undoIt() {
        if (this.copyObjects) {
            for (MyObject copyObject : this.copiedObjects) {
                copyObject.getPage().removeObject(copyObject);
            }
        } else {
            int i = 0;
            while (i < this.objectsToMove.size()) {
                MyObject object = this.objectsToMove.get(i);
                if (this.oldPage != this.newPage) {
                    this.newPage.removeObject(object);
                    this.oldPage.addObject(this.indexesInOldPage[i], object);
                }
                object.move(-this.dx, -this.dy);
                ++i;
            }
        }
        this.stateInfo.getMarkedObjects().clear();
        for (MyObject obj : this.oldMarkedObjects) {
            this.stateInfo.getMarkedObjects().add(obj);
        }
        this.stateInfo.getMarkedObjects().setPage(this.oldPage);
        return false;
    }
}

