/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.baseclasses.MarkedObjectsPreserveCommand;
import document.MyObject;
import document.Renderable;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import util.math.PointDouble;

public class RotateCommand
extends MarkedObjectsPreserveCommand {
    private MyObject object;
    private double angle;
    private PointDouble center;
    private MarkedObjectsAndHandles stateInfo;

    public RotateCommand(MarkedObjectsAndHandles stateInfo, MyObject objectToRotate, PointDouble center, double angle) {
        this.angle = angle;
        this.object = objectToRotate;
        this.center = center.getCopy();
        this.stateInfo = stateInfo;
        if (this.object.getType() == Renderable.ObjectType.markedObjects) {
            this.saveMarkedObjects(stateInfo);
        }
        objectToRotate.getDocument().getCommandManager().invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        if (this.object.getType() == Renderable.ObjectType.markedObjects) {
            this.restoreMarkedObjects(this.stateInfo);
        }
        this.object.rotate(this.center, this.angle);
        return Math.abs(this.angle) > 1.0E-6;
    }

    @Override
    public final boolean undoIt() {
        if (this.object.getType() == Renderable.ObjectType.markedObjects) {
            this.restoreMarkedObjects(this.stateInfo);
        }
        this.object.rotate(this.center, -this.angle);
        return false;
    }
}

