/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.view.Borders;
import document.view.MyView;

public class SetBorderOfViewCommand
extends AbstractCommand {
    float oldBorder;
    float newBorder;
    BorderLocation location;
    MyView view;

    public SetBorderOfViewCommand(BorderLocation location, float newBorder, MyView view) {
        this.location = location;
        this.newBorder = newBorder;
        this.view = view;
        switch (location) {
            case left: {
                this.oldBorder = view.getBorders().getLeft();
                break;
            }
            case right: {
                this.oldBorder = view.getBorders().getRight();
                break;
            }
            case top: {
                this.oldBorder = view.getBorders().getTop();
                break;
            }
            case bottom: {
                this.oldBorder = view.getBorders().getBottom();
                break;
            }
        }
        boolean mergeCommands = false;
        CommandManager commandManager = view.getDocument().getCommandManager();
        if (commandManager.getLastCommand() instanceof SetBorderOfViewCommand) {
            SetBorderOfViewCommand lastCommand = (SetBorderOfViewCommand)commandManager.getLastCommand();
            if (lastCommand.location == location && lastCommand.view == view) {
                lastCommand.newBorder = newBorder;
                mergeCommands = true;
            }
        }
        if (!mergeCommands) {
            commandManager.invokeCommand(this);
        } else {
            this.doIt();
        }
    }

    @Override
    public boolean doIt() {
        Borders borders = this.view.getBorders();
        switch (this.location) {
            case left: {
                borders.setLeft(this.newBorder);
                break;
            }
            case right: {
                borders.setRight(this.newBorder);
                break;
            }
            case top: {
                borders.setTop(this.newBorder);
                break;
            }
            case bottom: {
                borders.setBottom(this.newBorder);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean undoIt() {
        Borders borders = this.view.getBorders();
        switch (this.location) {
            case left: {
                borders.setLeft(this.oldBorder);
                break;
            }
            case right: {
                borders.setRight(this.oldBorder);
                break;
            }
            case top: {
                borders.setTop(this.oldBorder);
                break;
            }
            case bottom: {
                borders.setBottom(this.oldBorder);
                break;
            }
        }
        return false;
    }

    public static enum BorderLocation {
        left,
        right,
        top,
        bottom;

    }
}

