/*
 * Decompiled with CFR 0.152.
 */
package commands.changemarkfield;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.TextStyleChangeable;
import document.text.TextStyle;
import document.text.TextStyleFactory;

public class SetFontNameCommand
extends AbstractCommand {
    private String oldFontname;
    private String newFontname;
    private TextStyleChangeable textStyleChangeable;

    public SetFontNameCommand(String newFontname, TextStyleChangeable textStyleChangeable, CommandManager commandManager) {
        this.textStyleChangeable = textStyleChangeable;
        this.newFontname = newFontname;
        this.oldFontname = textStyleChangeable.getTextStyle().getFontName();
        commandManager.invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        TextStyle ots = this.textStyleChangeable.getTextStyle();
        TextStyle newTextStyle = TextStyleFactory.getInstance().getTextStyle(this.newFontname, ots.getSize(), ots.getFontColor(), ots.isUnderlined(), ots.isBold(), ots.isItalic());
        this.textStyleChangeable.setTextStyle(newTextStyle);
        return true;
    }

    @Override
    public final boolean undoIt() {
        TextStyle ots = this.textStyleChangeable.getTextStyle();
        TextStyle newTextStyle = TextStyleFactory.getInstance().getTextStyle(this.oldFontname, ots.getSize(), ots.getFontColor(), ots.isUnderlined(), ots.isBold(), ots.isItalic());
        this.textStyleChangeable.setTextStyle(newTextStyle);
        return false;
    }
}

