/*
 * Decompiled with CFR 0.152.
 */
package commands.changemarkfield;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.TextStyleChangeable;
import document.text.TextStyle;
import document.text.TextStyleFactory;

public class SetItalicCommand
extends AbstractCommand {
    private boolean newItalic;
    private boolean oldItalic;
    private TextStyleChangeable textStyleChangeable;

    public SetItalicCommand(boolean newItalic, TextStyleChangeable textStyleChangeable, CommandManager commandManager) {
        this.textStyleChangeable = textStyleChangeable;
        this.newItalic = newItalic;
        this.oldItalic = textStyleChangeable.getTextStyle().isItalic();
        commandManager.invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        TextStyle ots = this.textStyleChangeable.getTextStyle();
        TextStyle newTextStyle = TextStyleFactory.getInstance().getTextStyle(ots.getFontName(), ots.getSize(), ots.getFontColor(), ots.isUnderlined(), ots.isBold(), this.newItalic);
        this.textStyleChangeable.setTextStyle(newTextStyle);
        return true;
    }

    @Override
    public final boolean undoIt() {
        TextStyle ots = this.textStyleChangeable.getTextStyle();
        TextStyle newTextStyle = TextStyleFactory.getInstance().getTextStyle(ots.getFontName(), ots.getSize(), ots.getFontColor(), ots.isUnderlined(), ots.isBold(), this.oldItalic);
        this.textStyleChangeable.setTextStyle(newTextStyle);
        return false;
    }
}

