/*
 * Decompiled with CFR 0.152.
 */
package commands.changetext;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.text.AttributedText;
import document.text.TextFieldController;
import document.text.chunks.Chunk;
import document.text.textstylechanger.ItalicsChanger;
import java.util.ArrayList;

public class ChangeTextStyleItalicCommand
extends AbstractCommand {
    private int from;
    private int to;
    private boolean italic;
    private ArrayList<Chunk> oldChunks = null;
    private TextFieldController controller;

    public ChangeTextStyleItalicCommand(int from, int to, boolean italic, TextFieldController controller, CommandManager commandManager) {
        this.from = from;
        this.to = to;
        this.italic = italic;
        this.controller = controller;
        if (from > to) {
            int z = this.from;
            this.from = to;
            this.to = z;
        }
        commandManager.invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        ItalicsChanger textStyleChanger = new ItalicsChanger(this.italic);
        this.oldChunks = attributedText.changeTextStyle(this.from, this.to, textStyleChanger);
        return true;
    }

    @Override
    public final boolean undoIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        attributedText.undoFormatChange(this.oldChunks, this.from, this.to);
        return false;
    }
}

