/*
 * Decompiled with CFR 0.152.
 */
package commands.cutcopypaste;

import commands.baseclasses.AbstractCommand;
import commands.deleteobjectscommand.DeletedObject;
import document.MarkedObjects;
import document.MyObject;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import java.util.ArrayList;
import java.util.Collections;
import util.objectclipboard.ObjectClipboard;

public class CutObjectsCommand
extends AbstractCommand {
    private MarkedObjectsAndHandles stateInfo;
    private ArrayList<DeletedObject> deletedObjects = new ArrayList();

    public final void saveAndDeleteObjects() {
        this.deletedObjects.clear();
        for (MyObject object : this.stateInfo.getMarkedObjects().getObjects()) {
            DeletedObject dObject = new DeletedObject(object, object.getPage().objects.indexOf(object));
            this.deletedObjects.add(dObject);
            object.getPage().removeObject(object);
        }
        this.stateInfo.getMarkedObjects().clear();
    }

    public final void restoreDeletedAndMarkedObjects() {
        MarkedObjects mo = this.stateInfo.getMarkedObjects();
        mo.getObjects().clear();
        Collections.sort(this.deletedObjects);
        for (DeletedObject dObject : this.deletedObjects) {
            mo.add(dObject.getObject());
            dObject.getObject().getPage().addObject(dObject.getIndex(), dObject.getObject());
        }
        if (mo.size() > 0) {
            mo.setPage(mo.get(0).getPage());
        }
    }

    public CutObjectsCommand(MarkedObjectsAndHandles stateInfo) {
        this.stateInfo = stateInfo;
        ObjectClipboard.getInstance().copy(stateInfo.getMarkedObjects());
        stateInfo.getPageViewPortController().getDocument().getCommandManager().invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        this.saveAndDeleteObjects();
        this.stateInfo.clearMarkedObjects();
        this.stateInfo.getPageViewPortController().doRepaint();
        return true;
    }

    @Override
    public final boolean undoIt() {
        this.restoreDeletedAndMarkedObjects();
        return false;
    }
}

