/*
 * Decompiled with CFR 0.152.
 */
package commands.cutcopypaste;

import commands.baseclasses.AbstractCommand;
import document.MyGroup;
import document.MyObject;
import document.MyPage;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import util.math.PointDouble;
import util.objectclipboard.ObjectClipboard;

public class PasteObjectsCommand
extends AbstractCommand {
    private MyPage page;
    private MyGroup objectsToPaste = new MyGroup();

    public PasteObjectsCommand(MyPage page, PointDouble pos, boolean posIsRelative) {
        this.page = page;
        this.objectsToPaste = ObjectClipboard.getInstance().getContents();
        if (posIsRelative) {
            this.objectsToPaste.move(pos.x, pos.y);
            ObjectClipboard.getInstance().moveContents(pos.x, pos.y);
        } else {
            this.objectsToPaste.moveTo(pos);
        }
        if (page == null) {
            DocumentTabbedPaneController dTPC = DocumentTabbedPaneController.getInstance();
            PageViewPortController controller = dTPC.getActivePageScrollPaneController().getPageViewPortController();
            int index = (controller.getFirstVisiblePage() + controller.getLastVisiblePage()) / 2;
            this.page = controller.getView().getPage(index);
        }
        this.page.getDocument().getCommandManager().invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        DocumentTabbedPaneController dTPC = DocumentTabbedPaneController.getInstance();
        PageViewPortController controller = dTPC.getActivePageScrollPaneController().getPageViewPortController();
        MarkedObjectsAndHandles stateInfo = controller.getStateInfo();
        stateInfo.clearMarkedObjects();
        for (MyObject object : this.objectsToPaste.getObjects()) {
            this.page.addObject(object);
            stateInfo.getMarkedObjects().add(object);
        }
        stateInfo.setActionState();
        stateInfo.getHandlesOfMarkedObjects();
        controller.doRepaint();
        return true;
    }

    @Override
    public final boolean undoIt() {
        for (MyObject object : this.objectsToPaste.getObjects()) {
            this.page.removeObject(object);
        }
        return false;
    }
}

