/*
 * Decompiled with CFR 0.152.
 */
package commands.objectaligngroupzorder;

import commands.baseclasses.AbstractCommand;
import commands.objectaligngroupzorder.ObjectAlignInformation;
import document.MyObject;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import java.util.ArrayList;
import java.util.Collections;
import util.math.RectangleDouble;

public class ObjectAlignCommand
extends AbstractCommand {
    private MarkedObjectsAndHandles stateInfo;
    private ArrayList<ObjectAlignInformation> alignInformation = new ArrayList();

    public ObjectAlignCommand(MarkedObjectsAndHandles stateInfo, Alignment alignment) {
        this.stateInfo = stateInfo;
        for (MyObject object : stateInfo.getMarkedObjects().getObjects()) {
            this.alignInformation.add(new ObjectAlignInformation(object));
        }
        RectangleDouble rect = stateInfo.getMarkedObjects().getBoundingBox();
        switch (alignment) {
            case left: {
                this.alignLeft(rect.getLeft(), rect.getRight(), rect.getTop(), rect.getBottom());
                break;
            }
            case right: {
                this.alignRight(rect.getLeft(), rect.getRight(), rect.getTop(), rect.getBottom());
                break;
            }
            case top: {
                this.alignTop(rect.getLeft(), rect.getRight(), rect.getTop(), rect.getBottom());
                break;
            }
            case bottom: {
                this.alignBottom(rect.getLeft(), rect.getRight(), rect.getTop(), rect.getBottom());
                break;
            }
            case horizontalCenter: {
                this.alignHorizontalCenter(rect.getLeft(), rect.getRight(), rect.getTop(), rect.getBottom());
                break;
            }
            case verticalCenter: {
                this.alignVerticalCenter(rect.getLeft(), rect.getRight(), rect.getTop(), rect.getBottom());
                break;
            }
            case horizontalJustified: {
                this.alignHorizontalJustified(rect.getLeft(), rect.getRight(), rect.getTop(), rect.getBottom());
                break;
            }
            case verticalJustified: {
                this.alignVerticalJustified(rect.getLeft(), rect.getRight(), rect.getTop(), rect.getBottom());
                break;
            }
        }
        stateInfo.getMarkedObjectsPageController().getPage().getDocument().getCommandManager().invokeCommand(this);
    }

    private void alignLeft(double minX, double maxX, double minY, double maxY) {
        for (ObjectAlignInformation alignInfo : this.alignInformation) {
            alignInfo.setDx(minX - alignInfo.getObject().getBoundingBox().getLeft());
        }
    }

    private void alignRight(double minX, double maxX, double minY, double maxY) {
        for (ObjectAlignInformation alignInfo : this.alignInformation) {
            alignInfo.setDx(maxX - alignInfo.getObject().getBoundingBox().getRight());
        }
    }

    private void alignTop(double minX, double maxX, double minY, double maxY) {
        for (ObjectAlignInformation alignInfo : this.alignInformation) {
            alignInfo.setDy(minY - alignInfo.getObject().getBoundingBox().getTop());
        }
    }

    private void alignBottom(double minX, double maxX, double minY, double maxY) {
        for (ObjectAlignInformation alignInfo : this.alignInformation) {
            alignInfo.setDy(maxY - alignInfo.getObject().getBoundingBox().getTop());
        }
    }

    private void alignVerticalCenter(double minX, double maxX, double minY, double maxY) {
        double center = (minY + maxY) / 2.0;
        for (ObjectAlignInformation alignInfo : this.alignInformation) {
            RectangleDouble boundingBox = alignInfo.getObject().getBoundingBox();
            double centerObject = (boundingBox.getTop() + boundingBox.getBottom()) / 2.0;
            alignInfo.setDy(center - centerObject);
        }
    }

    private void alignHorizontalCenter(double minX, double maxX, double minY, double maxY) {
        double center = (minX + maxX) / 2.0;
        for (ObjectAlignInformation alignInfo : this.alignInformation) {
            RectangleDouble boundingBox = alignInfo.getObject().getBoundingBox();
            double centerObject = (boundingBox.getLeft() + boundingBox.getRight()) / 2.0;
            alignInfo.setDx(center - centerObject);
        }
    }

    private void alignHorizontalJustified(double minX, double maxX, double minY, double maxY) {
        double spaceAvailable = maxX - minX;
        double spaceNeeded = 0.0;
        for (ObjectAlignInformation alignInfo : this.alignInformation) {
            spaceNeeded += alignInfo.getObject().getBoundingBox().getWidth();
        }
        int numberOfBlanks = this.alignInformation.size() - 1;
        double blankWidth = (spaceAvailable - spaceNeeded) / (double)numberOfBlanks;
        ObjectAlignInformation.setCompareDirection(ObjectAlignInformation.CompareDirection.x);
        Collections.sort(this.alignInformation);
        double left = minX;
        int i = 0;
        while (i < this.alignInformation.size()) {
            ObjectAlignInformation alignInfo = this.alignInformation.get(i);
            alignInfo.setDx(left - alignInfo.getObject().getBoundingBox().getLeft());
            left = alignInfo.getObject().getBoundingBox().getRight() + alignInfo.getDx() + blankWidth;
            ++i;
        }
    }

    private void alignVerticalJustified(double minX, double maxX, double minY, double maxY) {
        double spaceAvailable = maxY - minY;
        double spaceNeeded = 0.0;
        for (ObjectAlignInformation alignInfo : this.alignInformation) {
            spaceNeeded += alignInfo.getObject().getBoundingBox().getHeight();
        }
        int numberOfBlanks = this.alignInformation.size() - 1;
        double blankWidth = (spaceAvailable - spaceNeeded) / (double)numberOfBlanks;
        ObjectAlignInformation.setCompareDirection(ObjectAlignInformation.CompareDirection.y);
        Collections.sort(this.alignInformation);
        double top = minY;
        int i = 0;
        while (i < this.alignInformation.size()) {
            ObjectAlignInformation alignInfo = this.alignInformation.get(i);
            alignInfo.setDy(top - alignInfo.getObject().getBoundingBox().getTop());
            top = alignInfo.getObject().getBoundingBox().getBottom() + alignInfo.getDy() + blankWidth;
            ++i;
        }
    }

    @Override
    public final boolean doIt() {
        for (ObjectAlignInformation alignInfo : this.alignInformation) {
            alignInfo.getObject().move(alignInfo.getDx(), alignInfo.getDy());
        }
        this.stateInfo.getMarkedObjects().setMetrics();
        this.stateInfo.getHandlesOfMarkedObjects();
        return true;
    }

    @Override
    public final boolean undoIt() {
        for (ObjectAlignInformation alignInfo : this.alignInformation) {
            alignInfo.getObject().move(-alignInfo.getDx(), -alignInfo.getDy());
        }
        this.stateInfo.getMarkedObjects().setMetrics();
        this.stateInfo.getHandlesOfMarkedObjects();
        return false;
    }

    public static enum Alignment {
        left,
        right,
        top,
        bottom,
        horizontalCenter,
        verticalCenter,
        horizontalJustified,
        verticalJustified;

    }
}

