/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DatabaseInterface;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public abstract class DataObject
extends Hashtable<String, Object> {
    private static DataObject[] deserializedObjectsInIndexOrder;
    int XMLIndex;
    int age = 0;
    protected Object index;
    private static DatabaseInterface databaseInterface;
    private boolean empty = true;

    static {
        databaseInterface = null;
    }

    public static DatabaseInterface getDatabaseInterface() {
        return databaseInterface;
    }

    public static void setDatabaseInterface(DatabaseInterface databaseInterface) {
        DataObject.databaseInterface = databaseInterface;
    }

    public void storeValue(String key, Object value) {
        this.put(key, value);
    }

    public Object getValue(String key) {
        Object value = this.get(key);
        if (value == null && this.empty && databaseInterface != null) {
            this.fetchData();
            value = this.get(key);
        }
        return value;
    }

    public String getStringValueNotNull(String key) {
        Object o;
        if (this.empty && databaseInterface != null) {
            this.fetchData();
        }
        if ((o = this.get(key)) != null && o instanceof String) {
            return (String)o;
        }
        return "";
    }

    public ArrayList<Object> getObjectListNotNull(String key) {
        Object o;
        if (this.empty && databaseInterface != null) {
            this.fetchData();
        }
        if ((o = this.get(key)) != null && o instanceof ArrayList) {
            return (ArrayList)o;
        }
        return new ArrayList<Object>();
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    protected void fetchData() {
        if (DataObject.getDatabaseInterface() != null) {
            ArrayList<DataObject> bufferedObjects = this.getBufferedObjects();
            if (bufferedObjects != null) {
                if (bufferedObjects.size() < this.getMaxBufferedObjects() - 1) {
                    bufferedObjects.add(this);
                } else {
                    int maxAge = bufferedObjects.get((int)0).age;
                    int indexOfOldestObject = 0;
                    int i = 1;
                    while (i < bufferedObjects.size()) {
                        int objectAge = bufferedObjects.get((int)i).age;
                        if (objectAge > maxAge) {
                            indexOfOldestObject = i;
                            maxAge = objectAge;
                        }
                        ++i;
                    }
                    bufferedObjects.get(indexOfOldestObject).cleanbuffer();
                    bufferedObjects.set(indexOfOldestObject, this);
                }
            }
            this.age = 0;
            this.retrieveDataFromDatabase();
        }
    }

    protected abstract void retrieveDataFromDatabase();

    public abstract void cleanbuffer();

    public Object getIndex() {
        return this.index;
    }

    public void setIndex(Object index) {
        this.index = index;
    }

    protected abstract ArrayList<DataObject> getBufferedObjects();

    protected abstract int getMaxBufferedObjects();

    protected void serializeKeyValuePairs(Element element) {
        this.fetchData();
        Set set = this.entrySet();
        for (Map.Entry entry : set) {
            XMLWriter.addAttribute(element, (String)entry.getKey(), entry.getValue().toString());
        }
        XMLWriter.addAttributeInt(element, "p_XMLIndex", this.getXMLIndex());
    }

    public abstract void serialize(Element var1);

    public abstract void deserialize(Element var1);

    protected void deserializeKeyValuePairs(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node node = attributes.item(i);
            String key = node.getNodeName();
            if (!key.startsWith("p_")) {
                String value = node.getTextContent();
                this.storeValue(key, value);
            } else if (key.compareTo("p_XMLIndex") == 0) {
                this.setXMLIndex(Integer.parseInt(node.getTextContent()));
                DataObject.registerDeserializedObject(this, this.getXMLIndex());
            }
            ++i;
        }
    }

    public int getXMLIndex() {
        return this.XMLIndex;
    }

    public void setXMLIndex(int index) {
        this.XMLIndex = index;
    }

    public static void prepareArrayForDeserializedObjects(int size) {
        deserializedObjectsInIndexOrder = new DataObject[size];
    }

    public static void registerDeserializedObject(DataObject dataObject, int index) {
        DataObject.deserializedObjectsInIndexOrder[index] = dataObject;
    }

    public static DataObject getDeserializedObject(int index) {
        return deserializedObjectsInIndexOrder[index];
    }

    public static void deleteArrayForDeserializedObjects() {
        deserializedObjectsInIndexOrder = null;
    }

    public abstract DataObject getNewInstance();

    public abstract void resolveXMLIndices();

    public void deserializeListOfDataObjects(Element element) {
        List<Element> elements = XMLReader.elements(element);
        for (Element childElement : elements) {
            DataObject dobj = this.getNewInstance();
            dobj.deserialize(childElement);
        }
    }

    public static void resolveAllXMLIndices() {
        DataObject[] dataObjectArray = deserializedObjectsInIndexOrder;
        int n = deserializedObjectsInIndexOrder.length;
        int n2 = 0;
        while (n2 < n) {
            DataObject dataObject = dataObjectArray[n2];
            dataObject.resolveXMLIndices();
            ++n2;
        }
    }

    protected ArrayList<Integer> StringListToInt(String s) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        int from = 0;
        int to = 0;
        while (to <= s.length()) {
            if ((to == s.length() || s.charAt(to) == ',') && to > 0) {
                String number = s.substring(from, to);
                numbers.add(Integer.parseInt(number));
                from = to + 1;
            }
            ++to;
        }
        return numbers;
    }
}

