/*
 * Decompiled with CFR 0.152.
 */
package data.localdatabase;

import data.DataObject;
import data.localdatabase.DBSchuelerDaten;
import data.localdatabase.DBSchulDaten;
import data.localdatabase.DBUserDaten;
import data.localdatabase.DBZeugnisDaten;
import java.util.ArrayList;
import org.w3c.dom.Element;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class DBKlassenDaten
extends DataObject {
    private static int MAXNUMBEROFBUFFEREDOBJECTS = 5;
    private static ArrayList<DataObject> bufferedObjects = new ArrayList();
    private ArrayList<DBUserDaten> users = new ArrayList();
    private String userXMLIndices;
    private DBSchulDaten schule;
    private int schulXMLIndex;
    private ArrayList<DBSchuelerDaten> schueler = new ArrayList();
    private String schuelerXMLIndices;
    private ArrayList<DBZeugnisDaten> zeugnisse = new ArrayList();
    private String zeugnisXMLIndices;

    public DBKlassenDaten(DBSchulDaten schule) {
        this.schule = schule;
    }

    public ArrayList<DBUserDaten> getUsers() {
        this.retrieveDataFromDatabase();
        return this.users;
    }

    public DBSchulDaten getSchule() {
        return this.schule;
    }

    public ArrayList<DBSchuelerDaten> getSchueler() {
        this.retrieveDataFromDatabase();
        return this.schueler;
    }

    public ArrayList<DBZeugnisDaten> getZeugnisse() {
        this.retrieveDataFromDatabase();
        return this.zeugnisse;
    }

    public void setUsers(ArrayList<DBUserDaten> users) {
        this.users = users;
    }

    public void setSchule(DBSchulDaten schule) {
        this.schule = schule;
    }

    @Override
    public void cleanbuffer() {
        for (DBSchuelerDaten schuelerData : this.schueler) {
            schuelerData.cleanbuffer();
        }
        this.clear();
        this.setEmpty(true);
    }

    @Override
    protected ArrayList<DataObject> getBufferedObjects() {
        return bufferedObjects;
    }

    @Override
    protected int getMaxBufferedObjects() {
        return MAXNUMBEROFBUFFEREDOBJECTS;
    }

    @Override
    protected void retrieveDataFromDatabase() {
        if (DBKlassenDaten.getDatabaseInterface() != null) {
            if (this.schueler.size() == 0) {
                ArrayList<Object> schuelerIndices = DBKlassenDaten.getDatabaseInterface().getPupilIndices(this.getIndex());
                for (Object schuelerIndex : schuelerIndices) {
                    DBSchuelerDaten schuelerData = new DBSchuelerDaten(this);
                    schuelerData.setIndex(schuelerIndex);
                    this.schueler.add(schuelerData);
                }
            }
            if (this.zeugnisse.size() == 0) {
                ArrayList<Object> zeugnisIndices = DBKlassenDaten.getDatabaseInterface().getZeugnisIndices(this.getIndex());
                for (Object zeugnisIndex : zeugnisIndices) {
                    DBZeugnisDaten zeugnisData = new DBZeugnisDaten();
                    zeugnisData.setIndex(zeugnisIndex);
                    this.zeugnisse.add(zeugnisData);
                }
            }
            this.clear();
            DBKlassenDaten.getDatabaseInterface().getClassData(this.getIndex(), this);
            this.setEmpty(false);
        }
    }

    @Override
    public String toString() {
        return this.getStringValueNotNull("name");
    }

    @Override
    public void deserialize(Element element) {
        this.deserializeKeyValuePairs(element);
        this.schulXMLIndex = XMLReader.elementIntegerAttribute(element, "schule");
        this.userXMLIndices = XMLReader.attributeNotNull(element, "p_userXMLIndices");
        this.schuelerXMLIndices = XMLReader.attributeNotNull(element, "p_schuelerXMLIndices");
        this.zeugnisXMLIndices = XMLReader.attributeNotNull(element, "p_zeugnisXMLIndices");
    }

    @Override
    public DataObject getNewInstance() {
        return new DBKlassenDaten(null);
    }

    @Override
    public void resolveXMLIndices() {
        this.schule = (DBSchulDaten)DBKlassenDaten.getDeserializedObject(this.schulXMLIndex);
        this.users.clear();
        ArrayList<Integer> numbers = this.StringListToInt(this.userXMLIndices);
        for (Integer number : numbers) {
            this.users.add((DBUserDaten)DBKlassenDaten.getDeserializedObject(number));
        }
        this.schueler.clear();
        numbers = this.StringListToInt(this.schuelerXMLIndices);
        for (Integer number : numbers) {
            this.schueler.add((DBSchuelerDaten)DBKlassenDaten.getDeserializedObject(number));
        }
        this.zeugnisse.clear();
        numbers = this.StringListToInt(this.zeugnisXMLIndices);
        for (Integer number : numbers) {
            this.zeugnisse.add((DBZeugnisDaten)DBKlassenDaten.getDeserializedObject(number));
        }
    }

    @Override
    public void serialize(Element parentElement) {
        Element element = XMLWriter.addElement(this.getXMLName(), parentElement);
        this.serializeKeyValuePairs(element);
        XMLWriter.addAttributeInt(element, "schule", this.schule.getXMLIndex());
        StringBuffer indexBuffer = new StringBuffer();
        int i = 0;
        while (i < this.schueler.size()) {
            indexBuffer.append(this.schueler.get(i).getXMLIndex());
            if (i < this.schueler.size() - 1) {
                indexBuffer.append(',');
            }
            ++i;
        }
        XMLWriter.addAttribute(element, "p_schuelerXMLIndices", indexBuffer.toString());
        indexBuffer = new StringBuffer();
        i = 0;
        while (i < this.users.size()) {
            indexBuffer.append(this.users.get(i).getXMLIndex());
            if (i < this.users.size() - 1) {
                indexBuffer.append(',');
            }
            ++i;
        }
        XMLWriter.addAttribute(element, "p_userXMLIndices", indexBuffer.toString());
        indexBuffer = new StringBuffer();
        i = 0;
        while (i < this.zeugnisse.size()) {
            indexBuffer.append(this.zeugnisse.get(i).getXMLIndex());
            if (i < this.zeugnisse.size() - 1) {
                indexBuffer.append(',');
            }
            ++i;
        }
        XMLWriter.addAttribute(element, "p_zeugnisXMLIndices", indexBuffer.toString());
    }

    public String getXMLName() {
        return "klasse";
    }
}

