/*
 * Decompiled with CFR 0.152.
 */
package document;

import document.MyFillableObject;
import document.MyObject;
import document.Renderable;
import document.events.Eventtype;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.graphiccontext.GraphicContext;
import gui.components.pageviewport.handles.HandleController;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import org.w3c.dom.Element;
import util.math.MyMath;
import util.math.PointDouble;
import util.xml.XMLWriter;

public class MyEllipse
extends MyFillableObject
implements Renderable {
    public MyEllipse(double midx, double midy, double width, double height, double angle) {
        this.midX = midx;
        this.midY = midy;
        this.width = width;
        this.height = height;
        this.angle = angle;
        this.makeShape();
    }

    public MyEllipse() {
        this(1.0, 1.0, 1.0, 1.0, 0.0);
    }

    @Override
    public void copyTo(MyObject object) {
        super.copyTo(object);
    }

    @Override
    public Renderable.ObjectType getType() {
        return Renderable.ObjectType.ellipse;
    }

    @Override
    public boolean isInside(PointDouble pPage) {
        if (this.isInBoundigBox(pPage)) {
            boolean inStroke;
            double yz;
            double xz;
            PointDouble pz = pPage.getCopy();
            MyMath.rotate(pz, this.midX, this.midY, -this.angle);
            double x = pz.getX();
            double y = pz.getY();
            double strokeWidth = this.getStrokeWidth() / 2.0;
            if (strokeWidth < 0.05) {
                strokeWidth = 0.05;
            }
            boolean inPaint = false;
            boolean inPaintOrStroke = false;
            if (this.width >= 0.0 && this.height >= 0.0 && (xz = (x - this.midX) / (this.width / 2.0 + strokeWidth)) * xz + (yz = (y - this.midY) / (this.height / 2.0 + strokeWidth)) * yz <= 1.0) {
                inPaintOrStroke = true;
                xz = (x - this.midX) / (this.width / 2.0 - strokeWidth);
                yz = (y - this.midY) / (this.height / 2.0 - strokeWidth);
                if (xz * xz + yz * yz <= 1.0) {
                    inPaint = true;
                }
            }
            boolean bl = inStroke = inPaintOrStroke && !inPaint;
            return this.isPainted() && inPaint || this.isStroked() && inStroke;
        }
        return false;
    }

    @Override
    protected void makeShape() {
        this.shape = new Ellipse2D.Double(this.midX - this.width / 2.0, this.midY - this.height / 2.0, this.width, this.height);
    }

    @Override
    public MyObject getCopy() {
        MyEllipse object = new MyEllipse(0.0, 0.0, 0.0, 0.0, 0.0);
        this.copyTo(object);
        return object;
    }

    @Override
    public void getHandles(ArrayList<HandleController> handleList, PageViewport pageViewPort) {
        this.getDiagonalStretchingHandles(handleList, pageViewPort, false);
        this.getHorVertStretchingHandles(handleList, pageViewPort);
        this.getRotateHandle(handleList, pageViewPort);
    }

    @Override
    public void render(GraphicContext gc, boolean isPreview) {
        gc.setPageCoordinates(false);
        AffineTransform OldTransform = gc.getTransform();
        if (Math.abs(this.getAngle()) > 1.0E-4) {
            gc.rotate(-this.getAngle(), this.getMidX(), this.getMidY());
        }
        if (this.isPainted()) {
            this.setPaint(gc);
            gc.fill(this.getShape());
        }
        if (this.isStroked()) {
            this.setStroke(gc);
            gc.draw(this.getShape());
        }
        gc.setTransform(OldTransform);
    }

    public static String getXMLName() {
        return "ellipse";
    }

    @Override
    public void deSerialize(Element element) {
        super.deSerialize(element);
        this.makeShape();
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(MyEllipse.getXMLName(), parentElement);
        super.serialize(element);
        return element;
    }

    @Override
    public Eventtype[] getPossibleEvents() {
        return null;
    }
}

