/*
 * Decompiled with CFR 0.152.
 */
package document;

import document.Serializable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import org.w3c.dom.Element;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class MyLineStyle
implements Serializable {
    private BasicStroke stroke;
    private Color strokeColor = Color.black;
    private int alpha = 255;
    private boolean isStroked = true;
    private float lineWidth = 0.03f;
    public static float[][] dashStyles = new float[][]{{3.0f}, {3.0f, 1.0f}, {1.0f, 1.0f}, {3.0f, 1.0f, 1.0f, 1.0f}};
    private int dashStyle = 0;
    private float[] individualDashStyle;

    public static float[] makeIndividualDashStyle(int dashStyle, float lineWidth) {
        if (dashStyle != 0) {
            float[] individualDashStyle = new float[dashStyles[dashStyle].length];
            int i = 0;
            while (i < dashStyles[dashStyle].length) {
                individualDashStyle[i] = dashStyles[dashStyle][i] * (0.1f + lineWidth);
                ++i;
            }
            return individualDashStyle;
        }
        return null;
    }

    public MyLineStyle() {
        this.setStroke();
    }

    public void copyTo(MyLineStyle lineStyle) {
        lineStyle.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        lineStyle.strokeColor = new Color(this.strokeColor.getRed(), this.strokeColor.getGreen(), this.strokeColor.getBlue(), this.strokeColor.getAlpha());
        lineStyle.dashStyle = this.dashStyle;
        lineStyle.isStroked = this.isStroked;
        lineStyle.lineWidth = this.lineWidth;
        lineStyle.individualDashStyle = this.individualDashStyle;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke() {
        this.stroke = this.dashStyle == 0 ? new BasicStroke(this.lineWidth, 0, 0, 1.0f) : new BasicStroke(this.lineWidth, 0, 0, 1.0f, this.individualDashStyle, 0.0f);
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = new Color(strokeColor.getRed(), strokeColor.getGreen(), strokeColor.getBlue(), this.alpha);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.strokeColor = new Color(this.strokeColor.getRed(), this.strokeColor.getGreen(), this.strokeColor.getBlue(), alpha);
        this.alpha = alpha;
    }

    public double getStrokeWidth() {
        double linewidth = this.isStroked ? (double)this.lineWidth : 0.0;
        return linewidth;
    }

    public boolean isStroked() {
        return this.isStroked;
    }

    public void setStroked(boolean isStroked) {
        this.isStroked = isStroked;
    }

    public void setStroke(Graphics2D g2d) {
        if (this.isStroked) {
            g2d.setStroke(this.stroke);
            g2d.setColor(this.strokeColor);
        }
    }

    public int getDashStyle() {
        return this.dashStyle;
    }

    public void setDashStyle(int dashStyle) {
        this.dashStyle = dashStyle;
        this.individualDashStyle = MyLineStyle.makeIndividualDashStyle(dashStyle, this.lineWidth);
        this.setStroke();
    }

    public float getLineWidth() {
        if (this.isStroked) {
            return this.lineWidth;
        }
        return 0.0f;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        this.individualDashStyle = MyLineStyle.makeIndividualDashStyle(this.dashStyle, lineWidth);
        this.setStroke();
    }

    public MyLineStyle getCopy() {
        MyLineStyle lineStyle = new MyLineStyle();
        this.copyTo(lineStyle);
        return lineStyle;
    }

    public static String getXMLName() {
        return "linestyle";
    }

    @Override
    public void deSerialize(Element element) {
        Color c;
        Float f;
        Integer i;
        Boolean b = XMLReader.elementBooleanAttribute(element, "isstroked");
        if (b != null) {
            this.isStroked = b;
        }
        if ((i = XMLReader.elementIntegerAttribute(element, "alpha")) != null) {
            this.alpha = i;
        }
        if ((f = XMLReader.elementFloatAttribute(element, "linewidth")) != null) {
            this.lineWidth = f.floatValue();
        }
        if ((c = XMLReader.elementColorAttribute(element, "color")) != null) {
            this.strokeColor = c;
        }
        if ((i = XMLReader.elementIntegerAttribute(element, "dashstyle")) != null) {
            this.setDashStyle(i);
        }
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(MyLineStyle.getXMLName(), parentElement);
        XMLWriter.addAttributeBoolean(element, "isstroked", this.isStroked);
        XMLWriter.addAttributeInt(element, "alpha", this.alpha);
        XMLWriter.addAttributeInt(element, "dashstyle", this.dashStyle);
        XMLWriter.addAttributeFloat(element, "linewidth", this.lineWidth);
        XMLWriter.addAttributeColor(element, "color", this.strokeColor);
        return parentElement;
    }
}

