/*
 * Decompiled with CFR 0.152.
 */
package document;

import document.AbstractKeyboardFocusable;
import document.MyDataSharingObject;
import document.MyDocument;
import document.MyObject;
import document.ObjectFactory;
import document.Renderable;
import document.Serializable;
import document.text.MyTextField;
import document.view.MyView;
import init.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import util.math.PointDouble;
import util.math.RectangleDouble;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class MyPage
implements Renderable,
Serializable {
    private double widthcm;
    private double heightcm;
    private MyView view;
    public ArrayList<MyObject> objects = new ArrayList();
    private HashMap<Integer, MyObject> objectByIndex = new HashMap();

    public MyPage(double width, double height) {
        this.widthcm = width;
        this.heightcm = height;
    }

    public MyPage() {
        this(21.0, 29.7);
    }

    public static String getXMLName() {
        return "page";
    }

    public void addObject(MyObject object) {
        this.objects.add(object);
        this.objectByIndex.put(object.getIndex(), object);
        object.setPage(this);
        this.setDirty();
    }

    public void addObject(int zOrder, MyObject object) {
        this.objects.add(zOrder, object);
        object.setPage(this);
        this.setDirty();
    }

    public double getHeightcm() {
        return this.heightcm;
    }

    public void setHeightcm(double heightcm) {
        this.heightcm = heightcm;
        this.setDirty();
    }

    public double getWidthcm() {
        return this.widthcm;
    }

    public void setWidthcm(double widthcm) {
        this.widthcm = widthcm;
        this.setDirty();
    }

    @Override
    public Renderable.ObjectType getType() {
        return Renderable.ObjectType.page;
    }

    @Override
    public boolean isInside(PointDouble pPage) {
        return false;
    }

    @Override
    public RectangleDouble getBoundingBox() {
        return null;
    }

    public MyObject ObjectUnderCursor(PointDouble p) {
        MyObject foundObject = null;
        int i = this.objects.size() - 1;
        while (i >= 0) {
            MyObject object = this.objects.get(i);
            if (object.isInside(p)) {
                foundObject = object;
                break;
            }
            --i;
        }
        return foundObject;
    }

    public void removeObject(MyObject object) {
        this.objects.remove(object);
        this.objectByIndex.remove(object.getIndex());
        this.setDirty();
    }

    public ArrayList<MyObject> getObjects() {
        return this.objects;
    }

    public MyDocument getDocument() {
        return this.view.getDocument();
    }

    public MyView getview() {
        return this.view;
    }

    public void setView(MyView view) {
        this.view = view;
    }

    @Override
    public void deSerialize(Element element) {
        Double d = XMLReader.elementDoubleAttribute(element, "width");
        if (d != null) {
            this.widthcm = d;
        }
        if ((d = XMLReader.elementDoubleAttribute(element, "height")) != null) {
            this.heightcm = d;
        }
        List<Element> elements = XMLReader.elements(element);
        for (Element childElement : elements) {
            MyObject object = ObjectFactory.deSerialize(childElement, this);
            if (object == null) continue;
            this.addObject(object);
        }
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(MyPage.getXMLName(), parentElement);
        XMLWriter.addAttributeDouble(element, "width", this.widthcm);
        XMLWriter.addAttributeDouble(element, "height", this.heightcm);
        for (MyObject object : this.objects) {
            object.serialize(element);
        }
        return element;
    }

    public int getZOrder(MyObject object) {
        if (this.objects.contains(object)) {
            return this.objects.indexOf(object);
        }
        return -1;
    }

    public MyObject getObjectByIndex(int index) {
        return this.objectByIndex.get(index);
    }

    public void switchEditMode(Settings.ToggleEditModus editmode) {
        for (MyObject object : this.objects) {
            if (!(object instanceof MyTextField)) continue;
            ((MyTextField)object).switchEditMode(editmode);
        }
    }

    public void setDirty() {
        this.view.setDirty();
    }

    public MyPage getCopy(MyView newView) {
        MyPage page = new MyPage(this.widthcm, this.heightcm);
        page.setView(this.view);
        for (MyObject object : this.objects) {
            MyObject copyObject = object.getCopy();
            copyObject.setIndex(object.getIndex());
            if (copyObject instanceof MyDataSharingObject) {
                ((MyDataSharingObject)copyObject).setName(((MyDataSharingObject)object).getName());
            }
            page.addObject(copyObject);
        }
        for (MyObject object : page.getObjects()) {
            if (!(object instanceof AbstractKeyboardFocusable)) continue;
            AbstractKeyboardFocusable akf = (AbstractKeyboardFocusable)object;
            AbstractKeyboardFocusable sourceakf = (AbstractKeyboardFocusable)this.getObjectByIndex(object.getIndex());
            akf.copyTabIndices(sourceakf);
        }
        return page;
    }
}

