/*
 * Decompiled with CFR 0.152.
 */
package document.text;

import document.text.AttributedText;
import document.text.ChunkPosition;
import document.text.CursorShape;
import document.text.Line;
import document.text.TextFieldView;
import document.text.TextStyle;
import document.text.VerticalAlignment;
import document.text.chunks.Chunk;
import document.text.chunks.LineBreak;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import util.math.PointFloat;

public class AttributedTextLayouter {
    private ArrayList<Line> lines = new ArrayList();
    private HashMap<ChunkPosition, Line> oldLines = new HashMap();
    private HashMap<ChunkPosition, Line> newLines = new HashMap();
    long currentChunkTimeStamp = -1L;
    private AttributedText attributedText;
    private float width = 5.0f;
    private float height = 5.0f;

    public void setWidthHeight(float width, float height) {
        if ((double)Math.abs(this.width - width) > 1.0E-5 || (double)Math.abs(this.height - height) > 1.0E-5) {
            this.width = width;
            this.height = height;
            this.forceReformatWholeLayout();
        }
    }

    public AttributedTextLayouter(AttributedText attributedText) {
        this.attributedText = attributedText;
    }

    public ArrayList<Chunk> getChunks() {
        return this.attributedText.chunks;
    }

    public void forceReformatWholeLayout() {
        this.currentChunkTimeStamp = -1L;
        this.reformatWholeLayout();
    }

    public void reformatDirtyLines() {
        if (this.currentChunkTimeStamp < this.attributedText.peekTimeStamp()) {
            long newTimeStamp = -1L;
            ArrayList<Chunk> chunks = this.getChunks();
            HashMap<ChunkPosition, Line> z = this.oldLines;
            this.oldLines = this.newLines;
            this.newLines = z;
            this.newLines.clear();
            this.lines.clear();
            int startIndexOfParagraph = -1;
            float topOfLine = 0.0f;
            int i = 0;
            while (i < chunks.size()) {
                Chunk chunk;
                if (startIndexOfParagraph == -1) {
                    startIndexOfParagraph = i;
                }
                if ((chunk = chunks.get(i)).getTimeStamp() > newTimeStamp) {
                    newTimeStamp = chunk.getTimeStamp();
                }
                if (chunk.isLineBreak()) {
                    ChunkPosition paragraphStart;
                    LineBreak lineBreak = (LineBreak)chunk;
                    ChunkPosition cp = paragraphStart = new ChunkPosition(chunks.get(startIndexOfParagraph), 0);
                    int cpChunkIndex = startIndexOfParagraph;
                    do {
                        Line lineToAdd;
                        Line oldLine;
                        if ((oldLine = this.oldLines.get(cp)) != null && lineBreak.getTimeStamp() <= this.currentChunkTimeStamp && !this.isLineDirty(oldLine, cpChunkIndex)) {
                            if ((double)Math.abs(topOfLine - oldLine.getTop()) > 1.0E-6) {
                                oldLine.doYShifting(topOfLine - oldLine.getTop());
                                oldLine.setTimeStamp(this.currentChunkTimeStamp + 1L);
                            }
                            this.newLines.put(cp, oldLine);
                            cp = oldLine.getEndChunkPosition().getCopy();
                            if (!cp.getChunk().isLineBreak()) {
                                cp.normalizeStringEndTo0();
                            }
                            lineToAdd = oldLine;
                            lineToAdd.setStartChunkIndex(cpChunkIndex);
                        } else {
                            Line line = new Line(this);
                            this.newLines.put(cp, line);
                            line.setStartChunkIndex(cpChunkIndex);
                            cp = line.layout(cp, cp == paragraphStart, topOfLine, lineBreak.getAlignment());
                            if (!cp.getChunk().isLineBreak()) {
                                cp.normalizeStringEndTo0();
                            }
                            line.setTimeStamp(this.currentChunkTimeStamp + 1L);
                            lineToAdd = line;
                            lineToAdd.calculateSumOfTimeStamps();
                        }
                        this.lines.add(lineToAdd);
                        topOfLine += lineToAdd.getAscent() + lineToAdd.getDescent() + lineToAdd.getLeading();
                        ChunkPosition endChunkPosition = lineToAdd.getEndChunkPosition();
                        if (endChunkPosition.getPosition() == endChunkPosition.getChunk().getLength()) {
                            cpChunkIndex += lineToAdd.getNumberOfChunks();
                            continue;
                        }
                        cpChunkIndex += lineToAdd.getNumberOfChunks() - 1;
                    } while (cp != null && !cp.getChunk().isLineBreak());
                    startIndexOfParagraph = -1;
                }
                ++i;
            }
            this.currentChunkTimeStamp = newTimeStamp;
        }
    }

    private boolean isLineDirty(Line line, int startIndexInChunksList) {
        ArrayList<Chunk> chunks = this.getChunks();
        int sumOfTimeStamps = 0;
        int i = startIndexInChunksList;
        while (i < startIndexInChunksList + line.getNumberOfChunks()) {
            if (i >= chunks.size()) {
                return true;
            }
            Chunk chunk = chunks.get(i);
            if (chunk.getTimeStamp() > this.currentChunkTimeStamp) {
                return true;
            }
            sumOfTimeStamps = (int)((long)sumOfTimeStamps + chunk.getTimeStamp());
            ++i;
        }
        return (long)sumOfTimeStamps != line.getSumOfTimeStamps();
    }

    public void reformatWholeLayout() {
        this.reformatDirtyLines();
    }

    public float calculateYOffset(VerticalAlignment vAlign, float borderTop, float borderBottom) {
        float textHeight = this.lines.size() > 0 ? this.lines.get(this.lines.size() - 1).getBottom() - this.lines.get(0).getTop() : 0.0f;
        switch (vAlign) {
            case top: {
                return 0.0f;
            }
            case center: {
                if (textHeight > this.height) {
                    return 0.0f;
                }
                return (this.height + borderTop + borderBottom - textHeight) / 2.0f - borderTop;
            }
            case bottom: {
                if (textHeight > this.height) {
                    return 0.0f;
                }
                return this.height - textHeight;
            }
        }
        return 0.0f;
    }

    public AttributedText getAttributedText() {
        return this.attributedText;
    }

    public ChunkPosition getHitPosition(float x, float y) {
        for (Line line : this.lines) {
            if (!(y <= line.getBottom())) continue;
            return line.getHitPosition(x, y);
        }
        return this.lines.get(this.lines.size() - 1).getHitPosition(x, y);
    }

    public PointFloat getPosition(ChunkPosition chunkPosition) {
        int chunkIndex = chunkPosition.getChunk().getIndex();
        int i = 0;
        while (i < this.lines.size()) {
            Line line = this.lines.get(i);
            if (line.getStartChunkIndex() + line.getNumberOfChunks() - 1 >= chunkIndex) {
                return line.getPosition(chunkPosition);
            }
            ++i;
        }
        return this.lines.get(this.lines.size() - 1).getPosition(chunkPosition);
    }

    public Line getLine(ChunkPosition chunkPosition) {
        int chunkIndex = chunkPosition.getChunk().getIndex();
        int lineIndex = this.lines.size() - 1;
        Line line = this.lines.get(lineIndex);
        int i = 0;
        while (i < this.lines.size()) {
            line = this.lines.get(i);
            if (line.getStartChunkIndex() + line.getNumberOfChunks() - 1 >= chunkIndex) {
                lineIndex = i;
                break;
            }
            ++i;
        }
        while (chunkPosition.getChunk() == line.getEndChunkPosition().getChunk() && chunkPosition.getPosition() > line.getEndChunkPosition().getPosition()) {
            if (lineIndex >= this.lines.size() - 1) break;
            line = this.lines.get(++lineIndex);
        }
        return line;
    }

    public ChunkPosition oneLineUp(ChunkPosition chunkPosition) {
        ChunkPosition pos;
        Line oldLine = this.getLine(chunkPosition);
        Line newLine = oldLine.getPreviousLine();
        if (newLine == null) {
            pos = chunkPosition.getCopy();
        } else {
            PointFloat p = oldLine.getPosition(chunkPosition);
            pos = newLine.getHitPosition(p.x, p.y - oldLine.getAscent());
        }
        return pos;
    }

    public ChunkPosition oneLineDown(ChunkPosition chunkPosition) {
        ChunkPosition pos;
        Line oldLine = this.getLine(chunkPosition);
        Line newLine = oldLine.getNextLine();
        if (newLine == null) {
            pos = chunkPosition.getCopy();
        } else {
            PointFloat p = oldLine.getPosition(chunkPosition);
            pos = newLine.getHitPosition(p.x, p.y + newLine.getAscent());
        }
        return pos;
    }

    public ChunkPosition oneCharacterRight(ChunkPosition chunkPosition) {
        return chunkPosition.getNextPositionOrSame();
    }

    public ChunkPosition oneCharacterLeft(ChunkPosition chunkPosition) {
        return chunkPosition.getPreviousPosition();
    }

    public CursorShape getCursorShape(ChunkPosition cp) {
        TextStyle ts = this.attributedText.getTextStyle(cp);
        return ts.getCursorShape(this.getPosition(cp));
    }

    public long render(TextFieldView tv, Rectangle2D boundsRect, long lastRenderedTimeStamp, boolean hasFocus, boolean printing) {
        for (Line line : this.lines) {
            if (line.getTimeStamp() <= lastRenderedTimeStamp || !hasFocus && line.getBottom() > this.height) continue;
            if (!printing) {
                tv.eraseBackground(line.getTop(), line.getBottom());
            }
            line.renderLine(tv, boundsRect);
        }
        return this.currentChunkTimeStamp;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
        this.forceReformatWholeLayout();
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
        this.reformatWholeLayout();
    }

    public void setAttributedText(AttributedText attributedText) {
        this.attributedText = attributedText;
        this.forceReformatWholeLayout();
    }

    public float getRealUsedTextHeight() {
        Line lastLine = this.lines.get(this.lines.size() - 1);
        return lastLine.getBottom();
    }

    public ArrayList<Line> getLines() {
        return this.lines;
    }

    public void resetTimeStamp() {
        this.currentChunkTimeStamp = -1L;
    }
}

